<?php
/**
 * @package languageDefines
 * @copyright Copyright 2003-2007 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: english.php 7440 2007-11-17 21:51:35Z drbyte $
 */

// FOLLOWING WERE moved to meta_tags.php
//define('TITLE', 'Zen Cart!');
//define('SITE_TAGLINE', 'El arte del of E-commerce');
//define('CUSTOM_KEYWORDS', 'ecommerce, código abierto, tienda, compra en línea');
// END: moved to meta_tags.php

  define('FOOTER_TEXT_BODY', 'Copyright &copy; ' . date('Y') . ' <a href="' . zen_href_link(FILENAME_DEFAULT) . '" target="_blank">' . STORE_NAME . '</a>. Powered by <a href="http://www.zen-cart.cn" target="_blank">Zen Cart</a>');

// look in your $PATH_LOCALE/locale directory for available locales..
// on RedHat try 'en_US'
// on FreeBSD try 'en_US.ISO_8859-1'
// on Windows try 'en', or 'English'
  @setlocale(LC_TIME, 'es_ES.utf-8');
  define('DATE_FORMAT_SHORT', '%d/%m/%Y');  // this is used for strftime()
  define('DATE_FORMAT_LONG', '%A %d %B, %Y'); // this is used for strftime()
  define('DATE_FORMAT', 'd/m/Y'); // this is used for date()
  define('DATE_TIME_FORMAT', DATE_FORMAT_SHORT . ' %H:%M:%S');

////
// Return date in raw format
// $date should be in format mm/dd/yyyy
// raw date is in format YYYYMMDD, or DDMMYYYY
  if (!function_exists('zen_date_raw')) {
    function zen_date_raw($date, $reverse = false) {
      if ($reverse) {
    		return substr($date, 0, 2) . substr($date, 3, 2) . substr($date, 6, 4);
      } else {
        return substr($date, 6, 4) . substr($date, 3, 2) . substr($date, 0, 2);
      }
    }
  }

// if USE_DEFAULT_LANGUAGE_CURRENCY is true, use the following currency, instead of the applications default currency (used when changing language)
  define('LANGUAGE_CURRENCY', 'EUR');

// Global entries for the <html> tag
  define('HTML_PARAMS','dir="ltr" lang="es"');

// charset for web pages and emails
  define('CHARSET', 'utf-8');

// footer text in includes/footer.php
  define('FOOTER_TEXT_REQUESTS_SINCE', 'solicitudes desde');

// Define the name of your Gift Certificate as Gift Voucher, Gift Certificate, Zen Cart Dollars, etc. here for use through out the shop
  define('TEXT_GV_NAME','Cupón de regalo');
  define('TEXT_GV_NAMES','Cupón de regalo');

// used for redeem code, redemption code, or redemption id
  define('TEXT_GV_REDEEM','Código de canjeo');

// used for redeem code sidebox
  define('BOX_HEADING_GV_REDEEM', TEXT_GV_NAME);
  define('BOX_GV_REDEEM_INFO', 'Código de canjeo: ');

// text for gender
  define('MALE', 'Sr.');
  define('FEMALE', 'Sra.');
  define('MALE_ADDRESS', 'Sr.');
  define('FEMALE_ADDRESS', 'Sra.');

// text for date of birth example
  define('DOB_FORMAT_STRING', 'dd/mm/aaaa');

//text for sidebox heading links
  define('BOX_HEADING_LINKS', '&nbsp;&nbsp;[más]');

// categories box text in sideboxes/categories.php
  define('BOX_HEADING_CATEGORIES', 'Categorías');

// manufacturers box text in sideboxes/manufacturers.php
  define('BOX_HEADING_MANUFACTURERS', 'Fabricantes');

// whats_new box text in sideboxes/whats_new.php
  define('BOX_HEADING_WHATS_NEW', 'Nuevos productos');
  define('CATEGORIES_BOX_HEADING_WHATS_NEW', 'Nuevos productos...');

  define('BOX_HEADING_FEATURED_PRODUCTS', 'Destacados');
  define('CATEGORIES_BOX_HEADING_FEATURED_PRODUCTS', 'Productos Destacados...');
  define('TEXT_NO_FEATURED_PRODUCTS', 'Los productos más destacados se añadirán pronto. Por favor, compruébelo más tarde.');

  define('TEXT_NO_ALL_PRODUCTS', 'Más productos serán añadidos próximamente. Por favor, compruébelo más tarde.');
  define('CATEGORIES_BOX_HEADING_PRODUCTS_ALL', 'Todos los productos...');

// quick_find box text in sideboxes/quick_find.php
  define('BOX_HEADING_SEARCH', 'Buscar');
  define('BOX_SEARCH_ADVANCED_SEARCH', 'Búsqueda Avanzada');

// specials box text in sideboxes/specials.php
  define('BOX_HEADING_SPECIALS', 'Especialidades');
  define('CATEGORIES_BOX_HEADING_SPECIALS','Especialidades ...');

// reviews box text in sideboxes/reviews.php
  define('BOX_HEADING_REVIEWS', 'Comentarios');
  define('BOX_REVIEWS_WRITE_REVIEW', 'Escriba un comentario sobre este producto.');
  define('BOX_REVIEWS_NO_REVIEWS', 'No hay comentarios de este producto actualmente.');
  define('BOX_REVIEWS_TEXT_OF_5_STARS', '¡%s de 5 Estrellas!');

// shopping_cart box text in sideboxes/shopping_cart.php
  define('BOX_HEADING_SHOPPING_CART', 'Carrito de la compra');
  define('BOX_SHOPPING_CART_EMPTY', 'Su carrito está vacío.');
  define('BOX_SHOPPING_CART_DIVIDER', 'ea.-&nbsp;');

// order_history box text in sideboxes/order_history.php
  define('BOX_HEADING_CUSTOMER_ORDERS', 'Volver a pedir rápidamente');

// best_sellers box text in sideboxes/best_sellers.php
  define('BOX_HEADING_BESTSELLERS', 'Los más vendidos');
  define('BOX_HEADING_BESTSELLERS_IN', 'Los más vendidos en<br />&nbsp;&nbsp;');

// notifications box text in sideboxes/products_notifications.php
  define('BOX_HEADING_NOTIFICATIONS', 'Notificaciones');
  define('BOX_NOTIFICATIONS_NOTIFY', 'Notificarme las actualizaciones de <strong>%s</strong>');
  define('BOX_NOTIFICATIONS_NOTIFY_REMOVE', 'No notificarme de actualizaciones de <strong>%s</strong>');

// manufacturer box text
  define('BOX_HEADING_MANUFACTURER_INFO', 'Información del fabricante');
  define('BOX_MANUFACTURER_INFO_HOMEPAGE', 'Página web %s ');
  define('BOX_MANUFACTURER_INFO_OTHER_PRODUCTS', 'Otros productos');

// languages box text in sideboxes/languages.php
  define('BOX_HEADING_LANGUAGES', 'Idiomas');

// currencies box text in sideboxes/currencies.php
  define('BOX_HEADING_CURRENCIES', 'Monedas');

// information box text in sideboxes/information.php
  define('BOX_HEADING_INFORMATION', 'Información');
  define('BOX_INFORMATION_PRIVACY', 'Declaración de privacidad');
  define('BOX_INFORMATION_CONDITIONS', 'Condiciones de Uso');
  define('BOX_INFORMATION_SHIPPING', 'Condiciones Generales');
  define('BOX_INFORMATION_CONTACT', 'Contactar con Nosotros');
  define('BOX_BBINDEX', 'Foro');
  define('BOX_INFORMATION_UNSUBSCRIBE', 'Cancelar la suscripción a las noticias');

  define('BOX_INFORMATION_SITE_MAP', 'Mapa Web');

// information box text in sideboxes/more_information.php - were TUTORIAL_
  define('BOX_HEADING_MORE_INFORMATION', 'Más información');
  define('BOX_INFORMATION_PAGE_2', 'Página 2');
  define('BOX_INFORMATION_PAGE_3', 'Página 3');
  define('BOX_INFORMATION_PAGE_4', 'Página 4');

// tell a friend box text in sideboxes/tell_a_friend.php
  define('BOX_HEADING_TELL_A_FRIEND', 'Decírselo a un Amigo');
  define('BOX_TELL_A_FRIEND_TEXT', 'Dar a conocer este producto.');

// wishlist box text in includes/boxes/wishlist.php
  define('BOX_HEADING_CUSTOMER_WISHLIST', 'Mi lista de deseos');
  define('BOX_WISHLIST_EMPTY', 'No hay nada en la lista de deseos');
  define('IMAGE_BUTTON_ADD_WISHLIST', 'Añadir a lista de deseos');
  define('TEXT_WISHLIST_COUNT', 'Hay %s deseos en su lista de deseos.');
  define('TEXT_DISPLAY_NUMBER_OF_WISHLIST', 'Mostrando <strong>%d</strong> a <strong>%d</strong> (de <strong>%d</strong> elementos en su lista de deseos)');

//New billing address text
  define('SET_AS_PRIMARY' , 'Establecer como dirección primaria');
  define('NEW_ADDRESS_TITLE', 'Dirección de pago');

// javascript messages
  define('JS_ERROR', 'Han ocurrido errores durante el proceso de su formulario.\n\nPor favor haga las siguientes correcciones:\n\n');

  define('JS_REVIEW_TEXT', '* Por favor, detalle un poco más su comentario. El comentario necesita tener al menos ' . REVIEW_TEXT_MIN_LENGTH . ' caracteres.');
  define('JS_REVIEW_RATING', '* Por favor elija la calificación para este artículo.');

  define('JS_ERROR_NO_PAYMENT_MODULE_SELECTED', '* Por favor seleccione la forma de pago de su pedido.');

  define('JS_ERROR_SUBMITTED', 'Este formulario ya ha sido enviado. Por favor presione Aceptar y espere que el proceso sea completado.');

  define('ERROR_NO_PAYMENT_MODULE_SELECTED', 'Por favor seleccione la forma de pago de su pedido.');
  define('ERROR_CONDITIONS_NOT_ACCEPTED', 'Por favor confirme los terminos y condiciones limitados a este pedido marcando la caja inferior.');
  define('ERROR_PRIVACY_STATEMENT_NOT_ACCEPTED', 'Por favor confirme la declaración de privacidad marcando la caja inferior.');

  define('CATEGORY_COMPANY', 'Detalles de la Empresa');
  define('CATEGORY_PERSONAL', 'Sus datos personales');
  define('CATEGORY_ADDRESS', 'Su dirección');
  define('CATEGORY_CONTACT', 'Su información de contacto');
  define('CATEGORY_OPTIONS', 'Opciones');
  define('CATEGORY_PASSWORD', 'Su Contraseña');
  define('CATEGORY_LOGIN', 'Inicio de Sesión');
  define('PULL_DOWN_DEFAULT', 'Por favor escoja su país');
  define('PLEASE_SELECT', 'Por favor seleccione...');
  define('TYPE_BELOW', 'Escriba su elección abajo ...');

  define('ENTRY_COMPANY', 'Nombre de la Empresa:');
  define('ENTRY_COMPANY_ERROR', 'Por favor introduzca el nombre de la empresa.');
  define('ENTRY_COMPANY_TEXT', '');
  define('ENTRY_GENDER', 'Forma de saludo:');
  define('ENTRY_GENDER_ERROR', 'Por favor escoja un saludo.');
  define('ENTRY_GENDER_TEXT', '*');
  define('ENTRY_FIRST_NAME', 'Nombre:');
  define('ENTRY_FIRST_NAME_ERROR', '¿Es su nombre correcto? Nuestro sistema requiere un mínimo de ' . ENTRY_FIRST_NAME_MIN_LENGTH . ' carácteres. Por favor inténtelo de nuevo.');
  define('ENTRY_FIRST_NAME_TEXT', '*');
  define('ENTRY_LAST_NAME', 'Apellidos:');
  define('ENTRY_LAST_NAME_ERROR', '¿Sus apellidos son correctos? Nuestro sistema requiere un mínimo de ' . ENTRY_LAST_NAME_MIN_LENGTH . ' carácteres. Por favor, inténtelo de nuevo.');
  define('ENTRY_LAST_NAME_TEXT', '*');
  define('ENTRY_DATE_OF_BIRTH', 'Fecha de Nacimiento:');
  define('ENTRY_DATE_OF_BIRTH_ERROR', '¿Su Fecha de nacimiento es correcta? Nuestro sistema requiere la fecha en el formato: DD/MM/AAAA (eg 21/05/1970)');
  define('ENTRY_DATE_OF_BIRTH_TEXT', '* (eg. 21/05/1970)');
  define('ENTRY_EMAIL_ADDRESS', 'Correo electrónico:');
  define('ENTRY_EMAIL_ADDRESS_ERROR', '¿Su dirección de correo es correcta? Debe contener al menos ' . ENTRY_EMAIL_ADDRESS_MIN_LENGTH . ' carácteres. Por favor inténtelo de nuevo.');
  define('ENTRY_EMAIL_ADDRESS_CHECK_ERROR', 'Lo sentimos, el sistema no entiende su correo electrónico. Por favor inténtelo de nuevo.');
  define('ENTRY_EMAIL_ADDRESS_ERROR_EXISTS', 'Ya existe una cuenta de cliente con este correo electrónico - por favor intente iniciar la sesión con esta dirección de correo. Si ya no usa este correo, puede corregirlo en la zona de Mi Cuenta.');
  define('ENTRY_EMAIL_ADDRESS_TEXT', '*');
  define('ENTRY_NICK', 'Pseudónimo para el Foro:');
  define('ENTRY_NICK_TEXT', '*'); // note to display beside nickname input field
  define('ENTRY_NICK_DUPLICATE_ERROR', 'Este pseudónimo ya se está usando. Por favor, pruebe otro.');
  define('ENTRY_NICK_LENGTH_ERROR', 'Por favor inténtelo de nuevo. Su pseudónimo debe contener al menos ' . ENTRY_NICK_MIN_LENGTH . ' carácteres.');
  define('ENTRY_STREET_ADDRESS', 'Dirección:');
  define('ENTRY_STREET_ADDRESS_ERROR', 'Su Dirección debe contener al menos un mínimo de ' . ENTRY_STREET_ADDRESS_MIN_LENGTH . ' carácteres.');
  define('ENTRY_STREET_ADDRESS_TEXT', '*');
  define('ENTRY_SUBURB', 'Localidad:');
  define('ENTRY_SUBURB_ERROR', '');
  define('ENTRY_SUBURB_TEXT', '');
  define('ENTRY_POST_CODE', 'Código Postal/Zip:');
  define('ENTRY_POST_CODE_ERROR', 'Su Código Postal/ZIP debe contener un mínimo de ' . ENTRY_POSTCODE_MIN_LENGTH . ' carácteres.');
  define('ENTRY_POST_CODE_TEXT', '*');
  define('ENTRY_CITY', 'Ciudad:');
  define('ENTRY_CUSTOMERS_REFERRAL', 'Código remisión:');

  define('ENTRY_CITY_ERROR', 'Su ciudad debe contener un mínimo de ' . ENTRY_CITY_MIN_LENGTH . ' carácteres.');
  define('ENTRY_CITY_TEXT', '*');
  define('ENTRY_STATE', 'Provincia/Estado:');
  define('ENTRY_STATE_ERROR', 'Su Provincia/Estado debe contener un mínimo de ' . ENTRY_STATE_MIN_LENGTH . ' carácteres.');
  define('ENTRY_STATE_ERROR_SELECT', 'Por favor seleccione un/a  provincia/estado del menú desplegable.');
  define('ENTRY_STATE_TEXT', '*');
  define('JS_STATE_SELECT', '-- Por favor escoja --');
  define('ENTRY_COUNTRY', 'País:');
  define('ENTRY_COUNTRY_ERROR', 'Debe seleccionar un país del menú desplegable de paises.');
  define('ENTRY_COUNTRY_TEXT', '*');
  define('ENTRY_TELEPHONE_NUMBER', 'Teléfono:');
  define('ENTRY_TELEPHONE_NUMBER_ERROR', 'Su teléfono debe contener un mínimo de ' . ENTRY_TELEPHONE_MIN_LENGTH . ' carácteres.');
  define('ENTRY_TELEPHONE_NUMBER_TEXT', '*');
  define('ENTRY_FAX_NUMBER', 'Número de Fax:');
  define('ENTRY_FAX_NUMBER_ERROR', '');
  define('ENTRY_FAX_NUMBER_TEXT', '');
  define('ENTRY_NEWSLETTER', 'Suscribirse a nuestras noticias.');
  define('ENTRY_NEWSLETTER_TEXT', '');
  define('ENTRY_NEWSLETTER_YES', 'Suscribirse');
  define('ENTRY_NEWSLETTER_NO', 'No suscribirse');
  define('ENTRY_NEWSLETTER_ERROR', '');
  define('ENTRY_PASSWORD', 'Contraseña:');
  define('ENTRY_PASSWORD_ERROR', 'Su contraseña debe contener un mínimo de ' . ENTRY_PASSWORD_MIN_LENGTH . ' carácteres.');
  define('ENTRY_PASSWORD_ERROR_NOT_MATCHING', 'La contraseña de confirmación debe coincidir con su contraseña.');
  define('ENTRY_PASSWORD_TEXT', '* (al menos ' . ENTRY_PASSWORD_MIN_LENGTH . ' carácteres)');
  define('ENTRY_PASSWORD_CONFIRMATION', 'Confirmar contraseña:');
  define('ENTRY_PASSWORD_CONFIRMATION_TEXT', '*');
  define('ENTRY_PASSWORD_CURRENT', 'Contraseña actual:');
  define('ENTRY_PASSWORD_CURRENT_TEXT', '*');
  define('ENTRY_PASSWORD_CURRENT_ERROR', 'Su contraseña debe contener un mínimo de ' . ENTRY_PASSWORD_MIN_LENGTH . ' carácteres.');
  define('ENTRY_PASSWORD_NEW', 'Nueva contraseña:');
  define('ENTRY_PASSWORD_NEW_TEXT', '*');
  define('ENTRY_PASSWORD_NEW_ERROR', 'Su nueva contraseña debe contener un mínimo de ' . ENTRY_PASSWORD_MIN_LENGTH . ' carácteres.');
  define('ENTRY_PASSWORD_NEW_ERROR_NOT_MATCHING', 'La confirmación de la contraseña debe coincidir con su nueva contraseña.');
  define('PASSWORD_HIDDEN', '--OCULTO--');

  define('FORM_REQUIRED_INFORMATION', '* Información requerida');
  define('ENTRY_REQUIRED_SYMBOL', '*');

  // constants for use in zen_prev_next_display function
  define('TEXT_RESULT_PAGE', '');
  define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS', 'Mostrando <strong>%d</strong> a <strong>%d</strong> (de <strong>%d</strong> productos)');
  define('TEXT_DISPLAY_NUMBER_OF_ORDERS', 'Mostrando <strong>%d</strong> a <strong>%d</strong> (de <strong>%d</strong> pedidos)');
  define('TEXT_DISPLAY_NUMBER_OF_REVIEWS', 'Mostrando <strong>%d</strong> a <strong>%d</strong> (de <strong>%d</strong> comentarios)');
  define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_NEW', 'Mostrando <strong>%d</strong> a <strong>%d</strong> (of <strong>%d</strong> nuevos productos)');
  define('TEXT_DISPLAY_NUMBER_OF_SPECIALS', 'Mostrando <strong>%d</strong> a <strong>%d</strong> (de <strong>%d</strong> especiales)');
  define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_FEATURED_PRODUCTS', 'Mostrando <strong>%d</strong> a <strong>%d</strong> (de <strong>%d</strong> productos destacados)');
  define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_ALL', 'Mostrando <strong>%d</strong> a <strong>%d</strong> (de <strong>%d</strong> productos)');

  define('PREVNEXT_TITLE_FIRST_PAGE', 'Primera página');
  define('PREVNEXT_TITLE_PREVIOUS_PAGE', 'Página anterior');
  define('PREVNEXT_TITLE_NEXT_PAGE', 'Página Siguiente');
  define('PREVNEXT_TITLE_LAST_PAGE', 'Última página');
  define('PREVNEXT_TITLE_PAGE_NO', 'Página %d');
  define('PREVNEXT_TITLE_PREV_SET_OF_NO_PAGE', 'Sistema anterior de %d páginas');
  define('PREVNEXT_TITLE_NEXT_SET_OF_NO_PAGE', 'Sistema siguiente de %d páginas');
  define('PREVNEXT_BUTTON_FIRST', '&lt;&lt;PRIMERO');
  define('PREVNEXT_BUTTON_PREV', '[&lt;&lt;&nbsp;Anterior]');
  define('PREVNEXT_BUTTON_NEXT', '[Siguiente&nbsp;&gt;&gt;]');
  define('PREVNEXT_BUTTON_LAST', 'Último&gt;&gt;');

  define('TEXT_BASE_PRICE','Desde ');

  define('TEXT_CLICK_TO_ENLARGE', 'agrandar imagen');

  define('TEXT_SORT_PRODUCTS', 'Ordenar productos ');
  define('TEXT_DESCENDINGLY', 'descendentemente');
  define('TEXT_ASCENDINGLY', 'ascendentemente');
  define('TEXT_BY', ' por ');

  define('TEXT_REVIEW_BY', 'por %s');
  define('TEXT_REVIEW_WORD_COUNT', '%s palabras');
  define('TEXT_REVIEW_RATING', 'Calificación: %s [%s]');
  define('TEXT_REVIEW_DATE_ADDED', 'Añadido la fecha: %s');
  define('TEXT_NO_REVIEWS', 'No hay comentarios actualmente.');

  define('TEXT_NO_NEW_PRODUCTS', 'Más productos serán añadidos próximamente. Por favor compruébelo más tarde.');

  define('TEXT_UNKNOWN_TAX_RATE', 'Impuesto de ventas');

  define('TEXT_REQUIRED', '<span class="errorText">Requerido</span>');

  define('WARNING_INSTALL_DIRECTORY_EXISTS', 'Advertencia: El directorio de instalación existe en: %s. Por motivos de seguridad elimínelo.');
  define('WARNING_CONFIG_FILE_WRITEABLE', 'Advertencia: Soy capaz de escribir en el fichero de configuración: %s. Esto es un riesgo potencial de seguridad - por favor configure los permisos apropiados a este fichero (solo-lectura, CHMOD 644 &oacute; 444 son típicos). Necesitará cambiarlos en su panel de control para cambiar los permisos de forma efectiva. Contacte con su Host Web para más ayuda. <a href="http://tutorials.zen-cart.com/index.php?article=90" target="_blank">Vea este FAQ</a>');
  define('ERROR_FILE_NOT_REMOVEABLE', 'Error: No se puede eliminar el fichero especificado. Debe usar el FTP para eliminar el fichero, debido a limitaciones en la configuración de los permisos en el servidor.');
  define('WARNING_SESSION_DIRECTORY_NON_EXISTENT', 'Advertencia: El directorio de sesiones no existe: ' . zen_session_save_path() . '. las sesiones no funcionarán hasta que este directorio sea creado.');
  define('WARNING_SESSION_DIRECTORY_NOT_WRITEABLE', 'Advertencia: No soy capaz de escribir en el directorio de sesiones: ' . zen_session_save_path() . '. Las sesiones no funcionar&aacute;n hasta que no se configuren los permisos correctos.');
  define('WARNING_SESSION_AUTO_START', 'Advertencia: session.auto_start está activado - por favor desactive esta característica PHP en php.ini y reinicie el servidor Web.');
  define('WARNING_DOWNLOAD_DIRECTORY_NON_EXISTENT', 'Advertencia: El directorio de productos descargables no existe: ' . DIR_FS_DOWNLOAD . '. Los productos descargables no estarán disponible hasta que exista el directorio.');
  define('WARNING_SQL_CACHE_DIRECTORY_NON_EXISTENT', 'Advertencia: El directorio de cache SQL no existe: ' . DIR_FS_SQL_CACHE . '. El cacheado SQL no funcionará hasta que este directorio sea creado.');
  define('WARNING_SQL_CACHE_DIRECTORY_NOT_WRITEABLE', 'Advertencia: No soy capaz de escribir en el directorio cache SQL: ' . DIR_FS_SQL_CACHE . '. El cacheado SQL no funcionará hasta que los permisos de usuario estén correctamente establecidos.');
  define('WARNING_DATABASE_VERSION_OUT_OF_DATE', 'Su base de datos parece necesitar parchearse a un altísimo nivel. Vaya a Administración->Utilidades->Información del servidor para comentar niveles de parches.');
  define('WARNING_COULD_NOT_LOCATE_LANG_FILE', 'ADVERTENCIA: No puedo localizar el archivo de idioma: ');

  define('TEXT_CCVAL_ERROR_INVALID_DATE', 'La fecha de expiración introducida no es válida. Por favor compruebe la fecha e inténtelo de nuevo.');
  define('TEXT_CCVAL_ERROR_INVALID_NUMBER', 'El número de la tarjeta de crédito introducido no es válido. Por favor compruebe el número e inténtelo de nuevo.');
  define('TEXT_CCVAL_ERROR_UNKNOWN_CARD', 'El número de la tarjeta de crédito que empieza con %s no fue introducido correctamente, o no aceptamos este tipo de tarjeta. Por favor, inténtelo de nuevo o use otra tajerta de crédito.');

  define('BOX_INFORMATION_DISCOUNT_COUPONS', 'Vales de descuento');
  define('BOX_INFORMATION_GV', TEXT_GV_NAME . ' FAQ');
  define('VOUCHER_BALANCE', TEXT_GV_NAME . ' Balance ');
  define('BOX_HEADING_GIFT_VOUCHER', TEXT_GV_NAME . ' Cuenta');
  define('GV_FAQ', TEXT_GV_NAME . ' FAQ');
  define('ERROR_REDEEMED_AMOUNT', 'Felicidades, lo ha canjeado');
  define('ERROR_NO_REDEEM_CODE', 'Usted no ha introducido un ' . TEXT_GV_REDEEM . '.');
  define('ERROR_NO_INVALID_REDEEM_GV', 'No válido ' . TEXT_GV_NAME . ' ' . TEXT_GV_REDEEM);
  define('TABLE_HEADING_CREDIT', 'Códigos disponibles');
  define('GV_HAS_VOUCHERA', 'Tiene fondos en su ' . TEXT_GV_NAME . ' Cuenta. Si quiere <br /> puede enviar esos fondos por <a class="pageResults" href="');

  define('GV_HAS_VOUCHERB', '"><strong>correo electrónico</strong></a> a alguien');
  define('ENTRY_AMOUNT_CHECK_ERROR', 'Usted no tiene suficientes fondos para enviar esta cantidad.');
  define('BOX_SEND_TO_FRIEND', 'Enviar ' . TEXT_GV_NAME . ' ');

  define('VOUCHER_REDEEMED',  TEXT_GV_NAME . ' canjeado');
  define('CART_COUPON', 'Cupón :');
  define('CART_COUPON_INFO', 'más info');
  define('TEXT_SEND_OR_SPEND','Usted tiene un balance disponible en su ' . TEXT_GV_NAME . ' cuenta. Usted puede gastarlo o enviarlo a alguien. Para enviar pulse en el botón inferior.');  
  define('TEXT_BALANCE_IS', 'Su ' . TEXT_GV_NAME . ' balance es: ');
  define('TEXT_AVAILABLE_BALANCE', 'Su ' . TEXT_GV_NAME . ' Cuenta');

// payment method is GV/Discount
  define('PAYMENT_METHOD_GV', 'Certificado de Regalo/Vale');
  define('PAYMENT_MODULE_GV', 'GV/DC');

  define('TABLE_HEADING_CREDIT_PAYMENT', 'Créditos disponibles');

  define('TEXT_INVALID_REDEEM_COUPON', 'Código del vale no válido');
  define('TEXT_INVALID_REDEEM_COUPON_MINIMUM', 'Usted debe gastar al menos %s para canjear este vale');
  define('TEXT_INVALID_STARTDATE_COUPON', 'Este vale ya no está disponible');
  define('TEXT_INVALID_FINISHDATE_COUPON', 'Este vale ya ha expirado');
  define('TEXT_INVALID_USES_COUPON', 'Este vale solo puede ser usado ');
  define('TIMES', ' veces.');
  define('TIME', ' vez.');
  define('TEXT_INVALID_USES_USER_COUPON', 'Usted ya ha utilizado este código de vale: %s el máximo número de veces permitidas por cliente. ');
  define('REDEEMED_COUPON', 'un cupón valorado ');
  define('REDEEMED_MIN_ORDER', 'en pedidos superiores ');
  define('REDEEMED_RESTRICTIONS', ' [aplicar restricciones Producto-Categoría]');
  define('TEXT_ERROR', 'Ha ocurrido un error');
  define('TEXT_INVALID_COUPON_PRODUCT', 'Este código de vale no es válido para algunos de los productos actuales de su carrito.');
  define('TEXT_VALID_COUPON', 'Felicidades, ha canjeado el vale de descuento');
  define('TEXT_REMOVE_REDEEM_COUPON_ZONE', 'El vale de descuento que ha introducido no es válido para la dirección que ha seleccionado.');

// more info in place of buy now
  define('MORE_INFO_TEXT','... más info');

// IP Address
  define('TEXT_YOUR_IP_ADDRESS','Su Dirección IP es: ');

//Generic Address Heading
  define('HEADING_ADDRESS_INFORMATION','Información de Dirección');

// cart contents
  define('PRODUCTS_ORDER_QTY_TEXT_IN_CART','Cantidad en el carrito: ');
  define('PRODUCTS_ORDER_QTY_TEXT','Añadir al carrito: ');

// success messages for added to cart when display cart is off
// set to blank for no messages
// for all pages except where multiple add to cart is used:
  define('SUCCESS_ADDED_TO_CART_PRODUCT', 'Producto añadido satisfactoriamente al carrito...');
// only for where multiple add to cart is used:
  define('SUCCESS_ADDED_TO_CART_PRODUCTS', 'Se han añadido satisfactoriamente los producto(s) seleccionados al carrito ...');

  define('TEXT_PRODUCT_WEIGHT_UNIT','kg');

// Shipping
  define('TEXT_SHIPPING_WEIGHT','kg');
  define('TEXT_SHIPPING_BOXES', 'Bultos');

// Discount Savings
  define('PRODUCT_PRICE_DISCOUNT_PREFIX','Ahorre:&nbsp;');
  define('PRODUCT_PRICE_DISCOUNT_PERCENTAGE','% descuento');
  define('PRODUCT_PRICE_DISCOUNT_AMOUNT','&nbsp;descuento');

// Sale Maker Sale Price
  define('PRODUCT_PRICE_SALE','Vender:&nbsp;');

//universal symbols
  define('TEXT_NUMBER_SYMBOL', '# ');

// banner_box
  define('BOX_HEADING_BANNER_BOX','Patrocinadores');
  define('TEXT_BANNER_BOX','Por favor visite a nuestros patrocinadores...');

// banner box 2
  define('BOX_HEADING_BANNER_BOX2','Ha visto ...');
  define('TEXT_BANNER_BOX2','¡Compre esto hoy!');

// banner_box - all
  define('BOX_HEADING_BANNER_BOX_ALL','Patrocinadores');
  define('TEXT_BANNER_BOX_ALL','Por favor, visite a nuestros patrocinadores...');

// boxes defines
  define('PULL_DOWN_ALL','Por favor seleccione');
  define('PULL_DOWN_MANUFACTURERS','- Reiniciar -');
// shipping estimator
  define('PULL_DOWN_SHIPPING_ESTIMATOR_SELECT', 'Por favor, seleccione');

// general Sort By
  define('TEXT_INFO_SORT_BY','Ordenar por: ');

// close window image popups
  define('TEXT_CLOSE_WINDOW',' - Haga click en la imagen para cerrar');
// close popups
  define('TEXT_CURRENT_CLOSE_WINDOW','[ Cerrar ventana ]');

// iii 031104 added:  File upload error strings
  define('ERROR_FILETYPE_NOT_ALLOWED', 'Error:  Tipo de archivo no permitido.');
  define('WARNING_NO_FILE_UPLOADED', 'Advertencia:  no se ha subido el fichero.');
  define('SUCCESS_FILE_SAVED_SUCCESSFULLY', 'Archivo guardado correctamente.');
  define('ERROR_FILE_NOT_SAVED', 'Error:  Fichero no guardado.');
  define('ERROR_DESTINATION_NOT_WRITEABLE', 'Error:  el destino no es escribible.');
  define('ERROR_DESTINATION_DOES_NOT_EXIST', 'Error: el destino no existe.');
  define('ERROR_FILE_TOO_BIG', 'Advertencia: ¡El fichero es demasido grande para ser cargado!<br />La orden puede ser ejecutada pero por favor contáctenos para ayudarle con la carga');
// End iii added

  define('TEXT_BEFORE_DOWN_FOR_MAINTENANCE', 'AVISO: Esta Web tiene programado un cierre por mantenimiento el: ');
  define('TEXT_ADMIN_DOWN_FOR_MAINTENANCE', 'AVISO: La Web está actualmente cerrada al público por mantenimiento');

  define('PRODUCTS_PRICE_IS_FREE_TEXT','¡Es gratis!');
  define('PRODUCTS_PRICE_IS_CALL_FOR_PRICE_TEXT','Contactar para el precio');
  define('TEXT_CALL_FOR_PRICE','Contactar para el precio');

  define('TEXT_INVALID_SELECTION',' Ha pulsado una selección no válida: ');
  define('TEXT_ERROR_OPTION_FOR',' en la opción para: ');
  define('TEXT_INVALID_USER_INPUT', 'Entrada de usuario requerida<br />');

// product_listing
  define('PRODUCTS_QUANTITY_MIN_TEXT_LISTING','Min: ');
  define('PRODUCTS_QUANTITY_UNIT_TEXT_LISTING','Unidades: ');
  define('PRODUCTS_QUANTITY_IN_CART_LISTING','En el carrito:');
  define('PRODUCTS_QUANTITY_ADD_ADDITIONAL_LISTING','Añadir adicionales:');

  define('PRODUCTS_QUANTITY_MAX_TEXT_LISTING','Max:');

  define('TEXT_PRODUCTS_MIX_OFF','*Mezclado OFF');
  define('TEXT_PRODUCTS_MIX_ON','*Mezclado ON');

  define('TEXT_PRODUCTS_MIX_OFF_SHOPPING_CART','<br />*Usted no puede mezclar las opciones en este artículo para conocer la cantidad mínima necesaria.*<br />');
  define('TEXT_PRODUCTS_MIX_ON_SHOPPING_CART','*Los valores de opción mixtos ON<br />');

  define('ERROR_MAXIMUM_QTY','La cantidad añadida a su carrito ha sido ajustada debido a una restricción máxima. Vea este artículo: ');
  define('ERROR_CORRECTIONS_HEADING','Por favor, corrija lo siguiente: <br />');
  define('ERROR_QUANTITY_ADJUSTED', 'La cantidad añadida a su carrito ha sido ajustada. El artículo que quería no está disponible en cantidades fraccionarias: ');
  define('ERROR_QUANTITY_CHANGED_FROM', ', ha sido cambiada de: ');
  define('ERROR_QUANTITY_CHANGED_TO', ' a ');
// Downloads Controller
  define('DOWNLOADS_CONTROLLER_ON_HOLD_MSG','AVISO: Las descargas no están disponibles hasta que el pago haya sido confirmado');
  define('TEXT_FILESIZE_BYTES', ' bytes');
  define('TEXT_FILESIZE_MEGS', ' MB');

// shopping cart errors
  define('ERROR_PRODUCT','El art&iacute;culo: ');
  define('ERROR_PRODUCT_STATUS_SHOPPING_CART','<br />Lo sentimos pero este producto ha sido eliminado de nuestro inventario.<br />Este artículo ha sido eliminado de su carrito de la compra.');
  define('ERROR_PRODUCT_QUANTITY_MIN',',  ... ERROR: existe una cantidad mínima de productos por pedido - ');
  define('ERROR_PRODUCT_QUANTITY_UNITS',' ... ERROR:se ha superado el máximo permitido de artículos en el carrito - ');
  define('ERROR_PRODUCT_OPTION_SELECTION','<br /> ... Valores de selección de opciones no válidos ');
  define('ERROR_PRODUCT_QUANTITY_ORDERED','<br /> Su pedido tiene un total de: ');
  define('ERROR_PRODUCT_QUANTITY_MAX',' ... ERROR:se ha superado el máximo permitido de productos en el carrito - ');
  define('ERROR_PRODUCT_QUANTITY_MIN_SHOPPING_CART',', ERROR: existe una cantidad mínima de productos por pedido. ');
  define('ERROR_PRODUCT_QUANTITY_UNITS_SHOPPING_CART',' ... ERROR:se ha superado el máximo permitido de artículos en el carrito - ');
  define('ERROR_PRODUCT_QUANTITY_MAX_SHOPPING_CART',' ... ERROR:se ha superado el máximo permitido de productos en el carrito - ');

  define('WARNING_SHOPPING_CART_COMBINED', 'AVISO: Para su comodidad, su carrito de la compra ha sido combinado con el carrito de la compra de su última visita. Por favor, compruebe su carrito de la compra antes de efectuar su pedido.');

// error on checkout when $_SESSION['customers_id' does not exist in customers table
  define('ERROR_CUSTOMERS_ID_INVALID', '¡ La información del cliente no ha podido ser validada!<br />Por favor inicie la sesión o vuelva a crear su cuenta...');

  define('TABLE_HEADING_FEATURED_PRODUCTS','Productos destacados');

  define('TABLE_HEADING_NEW_PRODUCTS', 'Nuevos productos para %s');
  define('TABLE_HEADING_UPCOMING_PRODUCTS', 'Productos en espera');
  define('TABLE_HEADING_DATE_EXPECTED', 'Fecha prevista');
  define('TABLE_HEADING_SPECIALS_INDEX', 'Especiales mensualmente para %s');

  define('CAPTION_UPCOMING_PRODUCTS','Estos artículos estarán en stock próximamente');
  define('SUMMARY_TABLE_UPCOMING_PRODUCTS','la tabla contiene un listado de productos próximamente disponibles así como sus fechas previstas');

// meta tags special defines
  define('META_TAG_PRODUCTS_PRICE_IS_FREE_TEXT','¡Es gratis!');

// customer login
  define('TEXT_SHOWCASE_ONLY','Contactar con Nosotros');
// set for login for prices
  define('TEXT_LOGIN_FOR_PRICE_PRICE','Precio no disponible');
  define('TEXT_LOGIN_FOR_PRICE_BUTTON_REPLACE','Inicie la sesión para conocer el precio');
// set for show room only
  define('TEXT_LOGIN_FOR_PRICE_PRICE_SHOWROOM', ''); // blank for prices or enter your own text
  define('TEXT_LOGIN_FOR_PRICE_BUTTON_REPLACE_SHOWROOM','Mostrar solo habitación');

// authorization pending
  define('TEXT_AUTHORIZATION_PENDING_PRICE', 'Precio no Disponible');
  define('TEXT_AUTHORIZATION_PENDING_BUTTON_REPLACE', 'APPROBACIÓN PENDIENTE');
  define('TEXT_LOGIN_TO_SHOP_BUTTON_REPLACE','Inicie la sesión para comprar');

// text pricing
  define('TEXT_CHARGES_WORD','Carga calculada:');
  define('TEXT_PER_WORD','<br />Precio por palabra: ');
  define('TEXT_WORDS_FREE',' Palabras(s) gratis ');
  define('TEXT_CHARGES_LETTERS','Carga Calculada:');
  define('TEXT_PER_LETTER','<br />Precio por letra: ');
  define('TEXT_LETTERS_FREE',' Letra(s) gratis ');
  define('TEXT_ONETIME_CHARGES','*cargada una vez = ');
  define('TEXT_ONETIME_CHARGES_EMAIL',"\t" . '*cargadas una vez = ');
  define('TEXT_ATTRIBUTES_QTY_PRICES_HELP', 'Opción de descuentos por cantidad');
  define('TABLE_ATTRIBUTES_QTY_PRICE_QTY','CANTIDAD');
  define('TABLE_ATTRIBUTES_QTY_PRICE_PRICE','PRECIO');
  define('TEXT_ATTRIBUTES_QTY_PRICES_ONETIME_HELP', 'Opciones de cargos únicos para descuentos por cantidad');

// textarea attribute input fields
  define('TEXT_MAXIMUM_CHARACTERS_ALLOWED',' carácteres máximos permitidos');
  define('TEXT_REMAINING','restante');

// Shipping Estimator
  define('CART_SHIPPING_OPTIONS', 'Estimar gastos de envío');
  define('CART_SHIPPING_OPTIONS_LOGIN', 'Por favor <a href="' . zen_href_link(FILENAME_LOGIN, '', 'SSL') . '"><span class="pseudolink">Inicie la sesión</span></a>, para ver los gastos de envío .');
  define('CART_SHIPPING_METHOD_TEXT', 'Métodos de envío disponibles');
  define('CART_SHIPPING_METHOD_RATES', 'Calificaciones');
  define('CART_SHIPPING_METHOD_TO','Enviar a: ');
  define('CART_SHIPPING_METHOD_TO_NOLOGIN', 'Enviar a: <a href="' . zen_href_link(FILENAME_LOGIN, '', 'SSL') . '"><span class="pseudolink">Iniciar sesión</span></a>');
  define('CART_SHIPPING_METHOD_FREE_TEXT','Envio gratuíto');
  define('CART_SHIPPING_METHOD_ALL_DOWNLOADS','- Descargas');
  define('CART_SHIPPING_METHOD_RECALCULATE','Recalcular');
  define('CART_SHIPPING_METHOD_ZIP_REQUIRED','verdadero');
  define('CART_SHIPPING_METHOD_ADDRESS','Dirección:');
  define('CART_OT','Estimación total del coste:');
  define('CART_OT_SHOW','verdadero'); // set to false if you don't want order totals
  define('CART_ITEMS','Artículos en su carrito: ');
  define('CART_SELECT','Seleccionar');
  define('ERROR_CART_UPDATE', '<strong>Por favor actualice su pedido.</strong> ');
  define('IMAGE_BUTTON_UPDATE_CART', 'Actualizar');
  define('EMPTY_CART_TEXT_NO_QUOTE', '¡Lo sentimos! Su sesión ha expirado ... Por favor, actualice su carrito de la compra para los gastos de envío ...');
  define('CART_SHIPPING_QUOTE_CRITERIA', 'Los gastos de envío están basados en la información que usted ha seleccionado:');

// multiple product add to cart
  define('TEXT_PRODUCT_LISTING_MULTIPLE_ADD_TO_CART', 'Añadir: ');
  define('TEXT_PRODUCT_ALL_LISTING_MULTIPLE_ADD_TO_CART', 'Añadir: ');
  define('TEXT_PRODUCT_FEATURED_LISTING_MULTIPLE_ADD_TO_CART', 'Añadir: ');
  define('TEXT_PRODUCT_NEW_LISTING_MULTIPLE_ADD_TO_CART', 'Añadir: ');
  //moved SUBMIT_BUTTON_ADD_PRODUCTS_TO_CART to button_names.php as BUTTON_ADD_PRODUCTS_TO_CART_ALT

// discount qty table
  define('TEXT_HEADER_DISCOUNT_PRICES_PERCENTAGE', 'Precio de descuentos por cantidad');
  define('TEXT_HEADER_DISCOUNT_PRICES_ACTUAL_PRICE', 'Nuevos precios descontados por cantidad');
  define('TEXT_HEADER_DISCOUNT_PRICES_AMOUNT_OFF', 'Precio de descuentos por cantidad');
  define('TEXT_FOOTER_DISCOUNT_QUANTITIES', '* Los descuentos varían según las opciones seleccionadas arriba');
  define('TEXT_HEADER_DISCOUNTS_OFF', 'Descuentos por cantidad no disponibles...');

// sort order titles for dropdowns
  define('PULL_DOWN_ALL_RESET','- REINICIAR - ');
  define('TEXT_INFO_SORT_BY_PRODUCTS_NAME', 'Nombre del producto');
  define('TEXT_INFO_SORT_BY_PRODUCTS_NAME_DESC', 'Nombre del producto - desc');
  define('TEXT_INFO_SORT_BY_PRODUCTS_PRICE', 'Precio - bajos a altos');
  define('TEXT_INFO_SORT_BY_PRODUCTS_PRICE_DESC', 'Precio - altos a bajos');
  define('TEXT_INFO_SORT_BY_PRODUCTS_MODEL', 'Modelo');
  define('TEXT_INFO_SORT_BY_PRODUCTS_DATE_DESC', 'Añadido la fecha - Recientes a Antiguos');
  define('TEXT_INFO_SORT_BY_PRODUCTS_DATE', 'Añadido la fecha - Antiguos a Recientes');
  define('TEXT_INFO_SORT_BY_PRODUCTS_SORT_ORDER', 'Mostrar por defecto');

// downloads module defines
  define('TABLE_HEADING_DOWNLOAD_DATE', 'El enlace expira');
  define('TABLE_HEADING_DOWNLOAD_COUNT', 'Restante');
  define('HEADING_DOWNLOAD', 'Para descargar sus ficheros pulse en el botón descargar y elija "Guardar en Disco" desde el menú desplegable.');
  define('TABLE_HEADING_DOWNLOAD_FILENAME','Nombre del fichero');
  define('TABLE_HEADING_PRODUCT_NAME','Nombre del elemento');
  define('TABLE_HEADING_BYTE_SIZE','Tamaño del fichero');
  define('TEXT_DOWNLOADS_UNLIMITED', 'Ilimitado');
  define('TEXT_DOWNLOADS_UNLIMITED_COUNT', '--- *** ---');

// misc
  define('COLON_SPACER', ':&nbsp;&nbsp;');

// table headings for cart display and upcoming products
  define('TABLE_HEADING_QUANTITY', 'Cantidad.');
  define('TABLE_HEADING_PRODUCTS', 'Nombre del elemento');
  define('TABLE_HEADING_TOTAL', 'Total');

// create account - login shared
  define('TABLE_HEADING_PRIVACY_CONDITIONS', 'Declaración de privacidad');
  define('TEXT_PRIVACY_CONDITIONS_DESCRIPTION', 'Por favor conozca nuestra declaración de privacidad pulsando en la siguiente caja. La declaración de privacidad puede ser leída <a href="' . zen_href_link(FILENAME_PRIVACY, '', 'SSL') . '"><span class="pseudolink">aquí</span></a>.');
  define('TEXT_PRIVACY_CONDITIONS_CONFIRM', 'He leído y estoy de acuerdo con su declaración de privacidad.');
  define('TABLE_HEADING_ADDRESS_DETAILS', 'Detalles de la dirección');
  define('TABLE_HEADING_PHONE_FAX_DETAILS', 'Detalles de contacto adicionales');
  define('TABLE_HEADING_DATE_OF_BIRTH', 'Verificación de su edad');
  define('TABLE_HEADING_LOGIN_DETAILS', 'Detalles de inicio de sesión');
  define('TABLE_HEADING_REFERRAL_DETAILS', '¿Estaba referido a nosotros?');

  define('ENTRY_EMAIL_PREFERENCE','Detalles de noticias y correo electrónico');
  define('ENTRY_EMAIL_HTML_DISPLAY','HTML');
  define('ENTRY_EMAIL_TEXT_DISPLAY','Solo Texto');
  define('EMAIL_SEND_FAILED','ERROR: Fallo al enviar el correo electrónico a: "%s" <%s> con asunto: "%s"');

  define('DB_ERROR_NOT_CONNECTED', 'Error - No se puede conectar a la base de datos');

// EZ-PAGES Alerts
  define('TEXT_EZPAGES_STATUS_HEADER_ADMIN', 'WARNING: EZ-PAGES HEADER - Activo únicamente para la IP del Administrador');
  define('TEXT_EZPAGES_STATUS_FOOTER_ADMIN', 'WARNING: EZ-PAGES FOOTER - Activo únicamente para la IP del Administrador');
  define('TEXT_EZPAGES_STATUS_SIDEBOX_ADMIN', 'WARNING: EZ-PAGES SIDEBOX - Activo únicamente para la IP del Administrador');

// extra product listing sorter
  define('TEXT_PRODUCTS_LISTING_ALPHA_SORTER', '');
  define('TEXT_PRODUCTS_LISTING_ALPHA_SORTER_NAMES', 'Productos que empiecen por...');
  define('TEXT_PRODUCTS_LISTING_ALPHA_SORTER_NAMES_RESET', '-- Reset --');

///////////////////////////////////////////////////////////
// include email extras
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_EMAIL_EXTRAS)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require_once(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_EMAIL_EXTRAS);

// include template specific header defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_HEADER)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require_once(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_HEADER);

// include template specific button name defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_BUTTON_NAMES)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require_once(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_BUTTON_NAMES);

// include template specific icon name defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_ICON_NAMES)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require_once(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_ICON_NAMES);

// include template specific other image name defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_OTHER_IMAGES_NAMES)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require_once(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_OTHER_IMAGES_NAMES);

// credit cards
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_CREDIT_CARDS)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require_once(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select. FILENAME_CREDIT_CARDS);

// include template specific whos_online sidebox defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_WHOS_ONLINE . '.php')) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require_once(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_WHOS_ONLINE . '.php');

// include template specific meta tags defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/meta_tags.php')) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require_once(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . 'meta_tags.php');

// END OF EXTERNAL LANGUAGE LINKS
?>