<?php
/**
 * @package languageDefines
 * @copyright Copyright 2003-2006 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: english.php 5454 2006-12-29 20:10:17Z drbyte $
 */

// FOLLOWING WERE moved to meta_tags.php
//define('TITLE', 'Zen Cart!');
//define('SITE_TAGLINE', 'The Art of E-commerce');
//define('CUSTOM_KEYWORDS', 'ecommerce, open source, shop, online shopping');
// END: moved to meta_tags.php

  define('FOOTER_TEXT_BODY', 'Copyright &copy; ' . date('Y') . ' <a href="http://www.zen-cart.com" target="_blank">Zen-Cart</a>. Powered by <a href="http://www.zen-cart.com" target="_blank">Zen-Cart</a>');

// look in your $PATH_LOCALE/locale directory for available locales..
// on RedHat try 'en_US'
// on FreeBSD try 'en_US.ISO_8859-1'
// on Windows try 'en', or 'English'
  @setlocale(LC_TIME, 'pt_PT.ISO_8859-1');
  define('DATE_FORMAT_SHORT', '%m/%d/%Y');  // this is used for strftime()
  define('DATE_FORMAT_LONG', '%A %d %B, %Y'); // this is used for strftime()
  define('DATE_FORMAT', 'm/d/Y'); // this is used for date()
  define('DATE_TIME_FORMAT', DATE_FORMAT_SHORT . ' %H:%M:%S');

////
// Return date in raw format
// $date should be in format mm/dd/yyyy
// raw date is in format YYYYMMDD, or DDMMYYYY
  if (!function_exists('zen_date_raw')) {
    function zen_date_raw($date, $reverse = false) {
      if ($reverse) {
        return substr($date, 3, 2) . substr($date, 0, 2) . substr($date, 6, 4);
      } else {
        return substr($date, 6, 4) . substr($date, 0, 2) . substr($date, 3, 2);
      }
    }
  }

// if USE_DEFAULT_LANGUAGE_CURRENCY is true, use the following currency, instead of the applications default currency (used when changing language)
  define('LANGUAGE_CURRENCY', 'EUR');

// Global entries for the <html> tag
  define('HTML_PARAMS','dir="ltr" lang="pt"');

// charset for web pages and emails
  define('CHARSET', 'iso-8859-1');

// footer text in includes/footer.php
  define('FOOTER_TEXT_REQUESTS_SINCE', 'pedidos desde');

// Define the name of your Gift Certificate as Gift Voucher, Gift Certificate, Zen Cart Dollars, etc. here for use through out the shop
  define('TEXT_GV_NAME','Vale Oferta');
  define('TEXT_GV_NAMES','Vales Oferta');

// used for redeem code, redemption code, or redemption id
  define('TEXT_GV_REDEEM','Cdigo de Resgate');

// used for redeem code sidebox
  define('BOX_HEADING_GV_REDEEM', TEXT_GV_NAME);
  define('BOX_GV_REDEEM_INFO', ' Cdigo de Resgate: ');

// text for gender
  define('MALE', 'Sr.');
  define('FEMALE', 'Sra.');
  define('MALE_ADDRESS', 'Sr.');
  define('FEMALE_ADDRESS', 'Sra.');

// text for date of birth example
  define('DOB_FORMAT_STRING', 'mm/dd/yyyy');

//text for sidebox heading links
  define('BOX_HEADING_LINKS', '&nbsp;&nbsp;[mais]');

// categories box text in sideboxes/categories.php
  define('BOX_HEADING_CATEGORIES', 'Categorias');

// manufacturers box text in sideboxes/manufacturers.php
  define('BOX_HEADING_MANUFACTURERS', 'Fabricantes');

// whats_new box text in sideboxes/whats_new.php
  define('BOX_HEADING_WHATS_NEW', 'Novos produtos');
  define('CATEGORIES_BOX_HEADING_WHATS_NEW', 'Novos produtos...');

  define('BOX_HEADING_FEATURED_PRODUCTS', 'Destaques');
  define('CATEGORIES_BOX_HEADING_FEATURED_PRODUCTS', 'Produtos em destaque...');
  define('TEXT_NO_FEATURED_PRODUCTS', 'Adicionaremos em breve mais produtos. Por favor, verifique mais tarde.');

  define('TEXT_NO_ALL_PRODUCTS', 'Adicionaremos em breve mais produtos. Por favor, verifique mais tarde.');
  define('CATEGORIES_BOX_HEADING_PRODUCTS_ALL', 'Todos os produtos ...');

// quick_find box text in sideboxes/quick_find.php
  define('BOX_HEADING_SEARCH', 'Procurar');
  define('BOX_SEARCH_ADVANCED_SEARCH', 'Procura Avanada');

// specials box text in sideboxes/specials.php
  define('BOX_HEADING_SPECIALS', 'Promoes');
  define('CATEGORIES_BOX_HEADING_SPECIALS','Promoes ...');

// reviews box text in sideboxes/reviews.php
  define('BOX_HEADING_REVIEWS', 'Comentrios');
  define('BOX_REVIEWS_WRITE_REVIEW', 'Escreva um comentrio acerca deste produto.');
  define('BOX_REVIEWS_NO_REVIEWS', 'No existe ainda nenhum comentrio referente a este produto.');
  define('BOX_REVIEWS_TEXT_OF_5_STARS', '%s num total de 5 estrelas!');

// shopping_cart box text in sideboxes/shopping_cart.php
  define('BOX_HEADING_SHOPPING_CART', 'Carrinho de Compras');
  define('BOX_SHOPPING_CART_EMPTY', 'O seu Carrinho de Compras est vazio.');
  define('BOX_SHOPPING_CART_DIVIDER', '&nbsp;unid.&nbsp;-&nbsp;');

// order_history box text in sideboxes/order_history.php
  define('BOX_HEADING_CUSTOMER_ORDERS', 'Fazer nova encomenda');

// best_sellers box text in sideboxes/best_sellers.php
  define('BOX_HEADING_BESTSELLERS', 'Os mais vendidos');
  define('BOX_HEADING_BESTSELLERS_IN', 'Os mais vendidos em<br />&nbsp;&nbsp;');

// notifications box text in sideboxes/products_notifications.php
  define('BOX_HEADING_NOTIFICATIONS', 'Notificaes');
  define('BOX_NOTIFICATIONS_NOTIFY', 'Notifiquem-me das actualizaes feitas em <strong>%s</strong>');
  define('BOX_NOTIFICATIONS_NOTIFY_REMOVE', 'No me notifiquem das actualizaes feitas em <strong>%s</strong>');

// manufacturer box text
  define('BOX_HEADING_MANUFACTURER_INFO', 'Informao referente ao fabricante');
  define('BOX_MANUFACTURER_INFO_HOMEPAGE', '%s Homepage');
  define('BOX_MANUFACTURER_INFO_OTHER_PRODUCTS', 'Outros produtos');

// languages box text in sideboxes/languages.php
  define('BOX_HEADING_LANGUAGES', 'Idiomas');

// currencies box text in sideboxes/currencies.php
  define('BOX_HEADING_CURRENCIES', 'Moedas');

// information box text in sideboxes/information.php
  define('BOX_HEADING_INFORMATION', 'Informao');
  define('BOX_INFORMATION_PRIVACY', 'Poltica de Privacidade');
  define('BOX_INFORMATION_CONDITIONS', 'Termos e Condies');
  define('BOX_INFORMATION_SHIPPING', 'Compras &amp; Devolues');
  define('BOX_INFORMATION_CONTACT', 'Contacte-nos');
  define('BOX_BBINDEX', 'Frum');
  define('BOX_INFORMATION_UNSUBSCRIBE', 'Anular Subscrio');

  define('BOX_INFORMATION_SITE_MAP', 'Mapa do Site');

// information box text in sideboxes/more_information.php - were TUTORIAL_
  define('BOX_HEADING_MORE_INFORMATION', 'Mais informao');
  define('BOX_INFORMATION_PAGE_2', 'Pgina 2');
  define('BOX_INFORMATION_PAGE_3', 'Pgina 3');
  define('BOX_INFORMATION_PAGE_4', 'Pgina 4');

// tell a friend box text in sideboxes/tell_a_friend.php
  define('BOX_HEADING_TELL_A_FRIEND', 'Informar um amigo');
  define('BOX_TELL_A_FRIEND_TEXT', 'Informe um amigo da existncia deste produto.');

// wishlist box text in includes/boxes/wishlist.php
  define('BOX_HEADING_CUSTOMER_WISHLIST', 'Lista de Desejos');
  define('BOX_WISHLIST_EMPTY', 'A sua lista de desejos no contm nenhum artigo');
  define('IMAGE_BUTTON_ADD_WISHLIST', 'Adicionar  lista de desejos');
  define('TEXT_WISHLIST_COUNT', 'A sua lista de desejos contm actualmente %s artigos.');
  define('TEXT_DISPLAY_NUMBER_OF_WISHLIST', 'Exibindo <strong>%d</strong> a <strong>%d</strong> (de um total de <strong>%d</strong> artigos da sua lista de desejos)');

//New billing address text
  define('SET_AS_PRIMARY' , 'Definir como endereo principal');
  define('NEW_ADDRESS_TITLE', 'Endereo de facturao');

// javascript messages
  define('JS_ERROR', 'Ocorreram vrios erros durante o processamento do seu formulrio.\n\nPor favor, efectue as seguintes correces:\n\n');

  define('JS_REVIEW_TEXT', '* Por favor, adicione algumas palavras mais aos seus comentrios. O comentrio tem de ter pelo menos ' . REVIEW_TEXT_MIN_LENGTH . ' caracteres.');
  define('JS_REVIEW_RATING', '* Por favor atribua uma classificao a este item.');

  define('JS_ERROR_NO_PAYMENT_MODULE_SELECTED', '* Por favor, seleccione um mtodo de pagamento para a sua encomenda.');

  define('JS_ERROR_SUBMITTED', 'Este formulrio j foi submetido. Seleccione OK e espere que o processamento dos dados seja completado.');

  define('ERROR_NO_PAYMENT_MODULE_SELECTED', 'Seleccione um mtodo de pagamento para a sua encomenda.');
  define('ERROR_CONDITIONS_NOT_ACCEPTED', 'Por favor, confirme os termos e condies associadas a esta encomenda, assinalando a caixa mais abaixo.');
  define('ERROR_PRIVACY_STATEMENT_NOT_ACCEPTED', 'Confirme a declarao de privacidade, assinalando a caixa mais abaixo.');

  define('CATEGORY_COMPANY', 'Dados da sua empresa');
  define('CATEGORY_PERSONAL', 'Dados pessoais');
  define('CATEGORY_ADDRESS', 'O seu endereo');
  define('CATEGORY_CONTACT', 'Os dados do seu contacto');
  define('CATEGORY_OPTIONS', 'Opes');
  define('CATEGORY_PASSWORD', 'A sua senha-pessoal');
  define('CATEGORY_LOGIN', 'Identificar');
  define('PULL_DOWN_DEFAULT', 'Por favor, seleccione o seu pas');
  define('PLEASE_SELECT', 'Por favor, seleccione ...');
  define('TYPE_BELOW', 'Digite a sua escolha mais abaixo ...');

  define('ENTRY_COMPANY', 'Nome da sua empresa:');
  define('ENTRY_COMPANY_ERROR', 'Por favor, insira o nome da sua empresa.');
  define('ENTRY_COMPANY_TEXT', '');
  define('ENTRY_GENDER', 'Saudao:');
  define('ENTRY_GENDER_ERROR', ' Por favor, escolha uma saudao.');
  define('ENTRY_GENDER_TEXT', '*');
  define('ENTRY_FIRST_NAME', 'Nome:');
  define('ENTRY_FIRST_NAME_ERROR', 'O seu primeiro nome est correcto? O nosso sistema requer um mnimo de ' . ENTRY_FIRST_NAME_MIN_LENGTH . ' caracteres. Por favor, tente de novo.');
  define('ENTRY_FIRST_NAME_TEXT', '*');
  define('ENTRY_LAST_NAME', 'Apelido:');
  define('ENTRY_FIRST_NAME_ERROR', 'O seu apelido est correcto? O nosso sistema requer um mnimo de ' . ENTRY_LAST_NAME_MIN_LENGTH . ' caracteres. Por favor, tente de novo.');
  define('ENTRY_LAST_NAME_TEXT', '*');
  define('ENTRY_DATE_OF_BIRTH', 'Data de nascimento:');
  define('ENTRY_DATE_OF_BIRTH_ERROR', 'A sua data de nascimento est correcta? O nosso sistema requer a data neste formato: MM/DD/AAAA (ex: 05/21/1970)');
  define('ENTRY_DATE_OF_BIRTH_TEXT', '* (ex.: 05/21/1970)');
  define('ENTRY_EMAIL_ADDRESS', 'Endereo electrnico:');
  define('ENTRY_EMAIL_ADDRESS_ERROR', ' O seu endereo electrnico est correcto? Ele dever conter pelo menos ' . ENTRY_EMAIL_ADDRESS_MIN_LENGTH . ' caracteres. Por favor, tente de novo.');
  define('ENTRY_EMAIL_ADDRESS_CHECK_ERROR', 'Desculpe, mas o sistema no compreende o seu endereo electrnico. Por favor, tente de novo.');
  define('ENTRY_EMAIL_ADDRESS_ERROR_EXISTS', 'O nosso sistem j contm um registo com esse endereo electrnico  por favor, tente registar-se nele com o mesmo endereo electrnico. Se j no usar esse endereo electrnico, poder alter-lo na rea A Minha Conta.');
  define('ENTRY_EMAIL_ADDRESS_TEXT', '*');
  define('ENTRY_NICK', 'Nome no Frum:');
  define('ENTRY_NICK_TEXT', '*'); // note to display beside nickname input field
  define('ENTRY_NICK_DUPLICATE_ERROR', 'Este nome j existe. Por favor, escolha outro.');
  define('ENTRY_NICK_LENGTH_ERROR', 'Por favor, tente de novo. O seu nome de utilizador dever conter pelo menos ' . ENTRY_NICK_MIN_LENGTH . ' caracteres.');
  define('ENTRY_STREET_ADDRESS', 'Endereo postal:');
  define('ENTRY_STREET_ADDRESS_ERROR', ' O seu endereo postal dever conter pelo menos ' . ENTRY_STREET_ADDRESS_MIN_LENGTH . ' caracteres.');
  define('ENTRY_STREET_ADDRESS_TEXT', '*');
  define('ENTRY_SUBURB', 'Complemento:');
  define('ENTRY_SUBURB_ERROR', '');
  define('ENTRY_SUBURB_TEXT', '');
  define('ENTRY_POST_CODE', 'Cdigo postal:');
  define('ENTRY_POST_CODE_ERROR', ' O seu cdigo postal dever conter pelo menos ' . ENTRY_POSTCODE_MIN_LENGTH . ' caracteres.');
  define('ENTRY_POST_CODE_TEXT', '*');
  define('ENTRY_CITY', 'Cidade:');
  define('ENTRY_CUSTOMERS_REFERRAL', 'Cdigo de referncia:');

  define('ENTRY_CITY_ERROR', 'O nome da sua cidade dever conter pelo menos ' . ENTRY_CITY_MIN_LENGTH . ' caracteres.');
  define('ENTRY_CITY_TEXT', '*');
  define('ENTRY_STATE', 'Distrito:');
  define('ENTRY_STATE_ERROR', ' O nome da sua regio dever conter pelo menos ' . ENTRY_STATE_MIN_LENGTH . ' caracteres.');
  define('ENTRY_STATE_ERROR_SELECT', 'Por favor, seleccione um Distrito na respectiva caixa de seleco.');
  define('ENTRY_STATE_TEXT', '*');
  define('JS_Estado_SELECT', '-- Please Choose --');
  define('ENTRY_COUNTRY', 'Pas:');
  define('ENTRY_COUNTRY_ERROR', 'Voc tem que que escolher um pas na respectiva caixa de seleco.');
  define('ENTRY_COUNTRY_TEXT', '*');
  define('ENTRY_TELEPHONE_NUMBER', 'Telefone:');
  define('ENTRY_TELEPHONE_NUMBER_ERROR', 'O seu nmero de telefone dever conter pelo menos ' . ENTRY_TELEPHONE_MIN_LENGTH . ' caracteres.');
  define('ENTRY_TELEPHONE_NUMBER_TEXT', '*');
  define('ENTRY_FAX_NUMBER', 'Fax:');
  define('ENTRY_FAX_NUMBER_ERROR', '');
  define('ENTRY_FAX_NUMBER_TEXT', '');
  define('ENTRY_NEWSLETTER', 'Subscreva o nosso boletim informativo.');
  define('ENTRY_NEWSLETTER_TEXT', '');
  define('ENTRY_NEWSLETTER_YES', 'Subscrever');
  define('ENTRY_NEWSLETTER_NO', 'Anular subscrio');
  define('ENTRY_NEWSLETTER_ERROR', '');
  define('ENTRY_PASSWORD', 'Senha-pessoal:');
  define('ENTRY_PASSWORD_ERROR', 'A sua senha-pessoal dever conter pelo menos ' . ENTRY_PASSWORD_MIN_LENGTH . ' caracteres.');
  define('ENTRY_PASSWORD_ERROR_NOT_MATCHING', 'A confirmao dever coincidir com a senha-pessoal que foi primeiramente introduzida.');
  define('ENTRY_PASSWORD_TEXT', '* (pelo menos ' . ENTRY_PASSWORD_MIN_LENGTH . ' caracteres)');
  define('ENTRY_PASSWORD_CONFIRMATION', 'Confirme a sua senha-pessoal:');
  define('ENTRY_PASSWORD_CONFIRMATION_TEXT', '*');
  define('ENTRY_PASSWORD_CURRENT', 'Senha-pessoal actual:');
  define('ENTRY_PASSWORD_CURRENT_TEXT', '*');
  define('ENTRY_PASSWORD_CURRENT_ERROR', 'A sua senha-pessoal dever conter pelo menos ' . ENTRY_PASSWORD_MIN_LENGTH . ' caracteres.');
  define('ENTRY_PASSWORD_NEW', 'Nova senha-pessoal:');
  define('ENTRY_PASSWORD_NEW_TEXT', '*');
  define('ENTRY_PASSWORD_NEW_ERROR', 'A sua senha-pessoal dever conter pelo menos ' . ENTRY_PASSWORD_MIN_LENGTH . ' caracteres.');
  define('ENTRY_PASSWORD_NEW_ERROR_NOT_MATCHING', 'A confirmao dever coincidir com a nova senha-pessoal.');
  define('PASSWORD_HIDDEN', '--HIDDEN--');

  define('FORM_REQUIRED_INFORMATION', '* Informao obrigatria');
  define('ENTRY_REQUIRED_SYMBOL', '*');

  // constants for use in zen_prev_next_display function
  define('TEXT_RESULT_PAGE', '');
  define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS', 'Exibindo de <strong>%d</strong> a <strong>%d</strong> (num total de <strong>%d</strong> produtos)');
  define('TEXT_DISPLAY_NUMBER_OF_ORDERS', 'Exibindo de <strong>%d</strong> a <strong>%d</strong> (num total de <strong>%d</strong> encomendas)');
  define('TEXT_DISPLAY_NUMBER_OF_REVIEWS', 'Exibindo de <strong>%d</strong> a <strong>%d</strong> (num total de <strong>%d</strong> comentrios)');
  define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_NEW', 'Exibindo de <strong>%d</strong> a <strong>%d</strong> (num total de<strong>%d</strong> produtos produtos)');
  define('TEXT_DISPLAY_NUMBER_OF_SPECIALS', 'Exibindo de <strong>%d</strong> a <strong>%d</strong> (num total de <strong>%d</strong> especiais)');
  define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_FEATURED_PRODUCTS', 'Exibindo de <strong>%d</strong> a <strong>%d</strong> (num total de <strong>%d</strong> produtos classificados)');
  define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_ALL', 'Exibindo de <strong>%d</strong> a <strong>%d</strong> (num total de <strong>%d</strong> produtos)');

  define('PREVNEXT_TITLE_FIRST_PAGE', 'Primeira pgina');
  define('PREVNEXT_TITLE_PREVIOUS_PAGE', 'Pgina anterior');
  define('PREVNEXT_TITLE_NEXT_PAGE', 'Prxima pgina');
  define('PREVNEXT_TITLE_LAST_PAGE', 'ltima pgina');
  define('PREVNEXT_TITLE_PAGE_NO', 'Pgina %d');
  define('PREVNEXT_TITLE_PREV_SET_OF_NO_PAGE', 'Conjunto de %d pginas anteriores');
  define('PREVNEXT_TITLE_NEXT_SET_OF_NO_PAGE', 'Prximo conjunto de %d pginas');
  define('PREVNEXT_BUTTON_FIRST', '&lt;&lt;PRIMEIRO');
  define('PREVNEXT_BUTTON_PREV', '[&lt;&lt;&nbsp;Anterior]');
  define('PREVNEXT_BUTTON_NEXT', '[Prximo&nbsp;&gt;&gt;]');
  define('PREVNEXT_BUTTON_LAST', 'LTIMO&gt;&gt;');

  define('TEXT_BASE_PRICE','Comear por: ');

  define('TEXT_CLICK_TO_ENLARGE', 'Ampliar Imagem');

  define('TEXT_SORT_PRODUCTS', 'Ordenar produtos ');
  define('TEXT_DESCENDINGLY', 'por ordem decrescente');
  define('TEXT_ASCENDINGLY', 'por ordem crescente');
  define('TEXT_BY', ' por ');

  define('TEXT_REVIEW_BY', 'por %s');
  define('TEXT_REVIEW_WORD_COUNT', '%s palavras');
  define('TEXT_REVIEW_RATING', 'Votao: %s [%s]');
  define('TEXT_REVIEW_DATE_ADDED', 'Dados adicionados: %s');
  define('TEXT_NO_REVIEWS', 'Actualmente no existe nenhum comentrio.');

  define('TEXT_NO_NEW_PRODUCTS', 'Em breve mais produtos em destaque. Por favor, verifique mais tarde.');

  define('TEXT_UNKNOWN_TAX_RATE', 'IVA');

  define('TEXT_REQUIRED', '<span class=""errorText"">Requirido</span>');

  $warn_path = (isset($_SERVER['SCRIPT_FILENAME']) ? @dirname($_SERVER['SCRIPT_FILENAME']) : '.....');
  define('WARNING_INSTALL_DIRECTORY_EXISTS', 'Aviso: O directrio de instalao j existe: ' . $warn_path . '/zc_install. Por favor, remova este directrio por motivos de segurana.');
  define('WARNING_CONFIG_FILE_WRITEABLE', 'Aviso: O arquivo de configurao est com permisso de escrita: ' . $warn_path . '/includes/configure.php. Isso  um potencial risco de segurana  por favor, defina correctamente os direitos de utilizador deste arquivo (read-only, CHMOD 644 ou 444 so os valores mais tpicos). Voc poder necessitar de utilizar o painel de controlo do seu espao na Internet, com vista a alterar efectivamente as respectivas permisses. Contacte a sua webhost para mais assistncia.');
  unset($warn_path);
  define('WARNING_SESSION_DIRECTORY_NON_EXISTENT', 'Aviso: O directrio sessions no existe: ' . zen_session_save_path() . '. As sesses no funcionaro at que este directrio seja criado.');
  define('WARNING_SESSION_DIRECTORY_NOT_WRITEABLE', 'Aviso: Eu no estou habilitado a escrever no directrio sessions: ' . zen_session_save_path() . '. As sesses no funcionaro at que se definam as permisses de utilizao correctas.');
  define('WARNING_SESSION_AUTO_START', 'Aviso: session.auto_start est activada  por favour, desactive esta propriedade PHP em php.ini e reinicie o seu servidor.');
  define('WARNING_DOWNLOAD_DIRECTORY_NON_EXISTENT', 'Aviso: O directrio downloadable products no existe: ' . DIR_FS_DOWNLOAD . '. Os produtos adquiridos por download no funcionaro at que este directrio seja vlido.');
  define('WARNING_SQL_CACHE_DIRECTORY_NON_EXISTENT', 'Aviso: O directrio SQL cache no existe: ' . DIR_FS_SQL_CACHE . '. O SQL caching no funcionar at que este directrio seja criado.');
  define('WARNING_SQL_CACHE_DIRECTORY_NOT_WRITEABLE', 'Aviso: Eu no estou habilitado a escrever no directrio SQL cache: ' . DIR_FS_SQL_CACHE . '. O SQL caching no funcionar at que se definam as permisses de utilizao correctas.');
  define('WARNING_DATABASE_VERSION_OUT_OF_DATE', 'A sua base de dados aparenta necessitar ser corrigida para um nvel superior. Ver Admin->Ferramentas->Informao do servidor para rever os nveis de correco.');


  define('TEXT_CCVAL_ERROR_INVALID_DATE', 'A data de expirao inserida para o carto de crdito  invlida. Por favor, verifique a data e tente de novo.');
  define('TEXT_CCVAL_ERROR_INVALID_NUMBER', 'O nmero do carto de crdito que foi inserido  invlido. Por favor, verifique o nmero e tente de novo.');
  define('TEXT_CCVAL_ERROR_UNKNOWN_CARD', 'O nmero do carto de crdito comeado por %s no foi inserido correctamente, ou no  aceite este tipo de carto. Por favor, tente de novo ou use um outro carto de crdito.');

  define('BOX_INFORMATION_DISCOUNT_COUPONS', 'Cupes de Desconto');
  define('BOX_INFORMATION_GV', TEXT_GV_NAME . ' - FAQ');
  define('VOUCHER_BALANCE', TEXT_GV_NAME . ' Saldo ');
  define('BOX_HEADING_GIFT_VOUCHER', TEXT_GV_NAME . ' Conta');
  define('GV_FAQ', TEXT_GV_NAME . ' PERGUNTAS FREQUENTES');
  define('ERROR_REDEEMED_AMOUNT', 'Parabns, voc converteu ');
  define('ERROR_NO_REDEEM_CODE', 'Voc no inseriu um ' . TEXT_GV_REDEEM . '.');
  define('ERROR_NO_INVALID_REDEEM_GV', 'Invlido ' . TEXT_GV_NAME . ' ' . TEXT_GV_REDEEM);
  define('TABLE_HEADING_CREDIT', 'Crdito disponvel');
  define('GV_HAS_VOUCHERA', 'Voc possui crdito na sua conta' . TEXT_GV_NAME . '. Se desejar <br />
                           poder enviar esses fundos a algum por <a class="pageResults" href="');

  define('GV_HAS_VOUCHERB', '"><strong>email</strong></a>');
  define('ENTRY_AMOUNT_CHECK_ERROR', 'Voc no possui crdito suficiente para poder enviar esta soma.');
  define('BOX_SEND_TO_FRIEND', 'Enviar ' . TEXT_GV_NAME . ' ');

  define('VOUCHER_REDEEMED',  TEXT_GV_NAME . ' Resgatado');
  define('CART_COUPON', 'Cupo :');
  define('CART_COUPON_INFO', 'mais informao');
  define('TEXT_SEND_OR_SPEND','Voc tambm possui saldo disponvel na sua conta' . TEXT_GV_NAME . '. Voc poder gast-lo ou envi-lo a algum. Para o enviar, clique no boto de baixo.');
  define('TEXT_Saldo_IS', 'O seu saldo de ' . TEXT_GV_NAME . '  de: ');
  define('TEXT_AVAILABLE_Saldo', 'A sua conta ' . TEXT_GV_NAME . ' ');

// payment method is GV/Discount
  define('PAYMENT_METHOD_GV', 'Vales de Oferta/Cupo');
  define('PAYMENT_MODULE_GV', 'GV/DC');

  define('TABLE_HEADING_CREDIT_PAYMENT', 'Crdito disponvel');

  define('TEXT_INVALID_REDEEM_COUPON', 'Cdigo invlido');
  define('TEXT_INVALID_REDEEM_COUPON_MINIMUM', 'Voc tem de gastar pelo menos %s para trocar este cupo');
  define('TEXT_INVALID_STARTDATE_COUPON', 'Este cupo ainda no est disponvel');
  define('TEXT_INVALID_FINISDATE_COUPON', 'O prazo deste cupo expirou');
  define('TEXT_INVALID_USES_COUPON', 'Este cupo podia ter sido usado apenas ');
  define('TIMES', ' vezes.');
  define('TIME', ' vez.');
  define('TEXT_INVALID_USES_USER_COUPON', 'Voc usou o cdigo do cupo: %s o nmero mximo de vezes permitido por cliente. ');
  define('REDEEMED_COUPON', 'um cupo no valor de ');
  define('REDEEMED_MIN_ORDER', 'em encomendas com um valor superior a ');
  define('REDEEMED_RESTRICTIONS', ' [Aplicam-se as restries referentes ao Produto-Categoria]');
  define('TEXT_ERROR', 'Ocorreu um erro');
  define('TEXT_INVALID_COUPON_PRODUCT', 'O cdigo deste cupo no  vlido para nenhum dos produtos actualmente contidos no seu Carrinho de Compras.');
  define('TEXT_VALID_COUPON', 'Parabns, voc converteu devidamente o seu cupo de desconto');
  define('TEXT_REMOVE_REDEEM_COUPON_ZONE', 'O cdigo do cupo que voc inseriu no  vlido para o endereo que voc seleccionou.');

// more info in place of buy now
  define('MORE_INFO_TEXT','... mais informaes');

// IP Address
  define('TEXT_YOUR_IP_ADDRESS','O seu endereo IP : ');

//Generic Address Heading
  define('HEADING_ADDRESS_INFORMATION','Informao do endereo');

// cart contents
  define('PRODUCTS_ORDER_QTY_TEXT_IN_CART','Quantidade contida no Carrinho de Compras: ');
  define('PRODUCTS_ORDER_QTY_TEXT','Adicionar ao Carrinho de Compras: ');

// success messages for added to cart when display cart is off
// set to blank for no messages
// for all pages except where multiple add to cart is used:
  define('SUCCESS_ADDED_TO_CART_PRODUCT', 'O produto foi adicionado ao Carrinho de Compras ...');
// only for where multiple add to cart is used:
  define('SUCCESS_ADDED_TO_CART_PRODUCTS', 'Os produtos seleccionados foram adicionados ao Carrinho de Compras com xito ...');

  define('TEXT_PRODUCT_WEIGHT_UNIT','lbs');

// Shipping
  define('TEXT_SHIPPING_WEIGHT','kg');
  define('TEXT_SHIPPING_BOXES', 'Caixas');

// Discount Savings
  define('PRODUCT_PRICE_DISCOUNT_PREFIX','Poupe:&nbsp;');
  define('PRODUCT_PRICE_DISCOUNT_PERCENTAGE','% menos');
  define('PRODUCT_PRICE_DISCOUNT_AMOUNT','&nbsp;menos');

// Sale Maker Sale Price
  define('PRODUCT_PRICE_SALE','Venda:&nbsp;');

//smbolos universais
  define('TEXT_NUMBER_SYMBOL', '# ');

// banner_box
  define('BOX_HEADING_BANNER_BOX','Patrocinadores');
  define('TEXT_BANNER_BOX','Visite os nossos patrocinadores ...');

// banner box 2
  define('BOX_HEADING_BANNER_BOX2','J conhece ...');
  define('TEXT_BANNER_BOX2','Verifique ainda hoje!');

// banner_box - all
  define('BOX_HEADING_BANNER_BOX_ALL','Patrocinadores');
  define('TEXT_BANNER_BOX_ALL','Visite os nossos patrocinadores ...');

// boxes defines
  define('PULL_DOWN_ALL','Por favor, seleccione');
  define('PULL_DOWN_MANUFACTURERS','- Actualizar -');
// Shipping estimator
  define('PULL_DOWN_SHIPPING_ESTIMATOR_SELECT', 'Por favor, seleccione');

// general Sort By
  define('TEXT_INFO_SORT_BY','Ordenar por: ');

// close window image popups
  define('TEXT_CLOSE_WINDOW','  Clique na imagem para fechar');
// close popups
  define('TEXT_CURRENT_CLOSE_WINDOW','[ Fechar janela ]');

// iii 031104 added:  File upload error strings
  define('ERROR_FILETYPE_NOT_ALLOWED', 'Erro:  Este tipo de ficheiro no  permitido.');
  define('WARNING_NO_FILE_UPLOADED', 'Aviso:  No foi carregado nenhum ficheiro.');
  define('SUCCESS_FILE_SAVED_SUCCESSFULLY', 'Sucesso:  o ficheiro foi salvo com xito.');
  define('ERROR_FILE_NOT_SAVED', 'Erro:  o ficheiro no foi salvo.');
  define('ERROR_DESTINATION_NOT_WRITEABLE', 'Erro:  no tem permisso de escrita para o destino escolhido.');
  define('ERROR_DESTINATION_DOES_NOT_EXIST', 'Erro: o destino indicado no existe.');
  define('ERROR_FILE_TOO_BIG', 'Aviso: O ficheiro  demasiado grande para poder ser carregado!<br />A encomenda pode ser efectuada mas contacte por favor o site para obter ajuda a carreg-lo');
// End iii added

  define('TEXT_BEFORE_DOWN_FOR_MAINTENANCE', 'INFORMAO: prev-se que este site esteja em manuteno no dia: ');
  define('TEXT_ADMIN_DOWN_FOR_MAINTENANCE', 'INFORMAO: este site est actualmente em manuteno, no podendo portanto ser acedido pelo pblico!');

  define('PRODUCTS_PRICE_IS_FREE_TEXT','Grtis!');
  define('PRODUCTS_PRICE_IS_CALL_FOR_PRICE_TEXT','Preo especial');
  define('TEXT_CALL_FOR_PRICE','Preo especial');

  define('TEXT_INVALID_SELECTION',' Voc optou por uma seleco invlida: ');
  define('TEXT_ERROR_OPTION_FOR',' Na opo de: ');
  define('TEXT_INVALID_USER_INPUT', 'Entrada do valor requerida<br />');

// product_listing
  define('PRODUCTS_QUANTITY_MIN_TEXT_LISTING','Mn:');
  define('PRODUCTS_QUANTITY_UNIT_TEXT_LISTING','Unidades:');
  define('PRODUCTS_QUANTITY_IN_CART_LISTING','No Carrinho de Compras:');
  define('PRODUCTS_QUANTITY_ADD_ADDITIONAL_LISTING','Adicionar:');

  define('PRODUCTS_QUANTITY_MAX_TEXT_LISTING','Mx:');

  define('TEXT_PRODUCTS_MIX_OFF','*Mistos DESLIGADO');
  define('TEXT_PRODUCTS_MIX_ON','*Mistos LIGADO');

  define('TEXT_PRODUCTS_MIX_OFF_SHOPPING_CART','*O tpico - Valores das opes mistas - est DESLIGADO<br />');
  define('TEXT_PRODUCTS_MIX_ON_SHOPPING_CART','*O tpico - Valores das opes mistas - est LIGADO<br />');

  define('ERROR_MAXIMUM_QTY','Qtd. ajustada - Quantidade mxima adicionada ao Carrinho de Compras ');
  define('ERROR_CORRECTIONS_HEADING','Por favor, corrija os seguintes valores: <br />');
  define('ERROR_QUANTITY_ADJUSTED', 'Ajuste do erro de quantidades<br />');

// Downloads Controller
  define('DOWNLOADS_CONTROLLER_ON_HOLD_MSG','NOTA: Os downloads s estaro disponveis depois do pagamento ter sido confirmado');
  define('TEXT_FILESIZE_BYTES', ' bytes');
  define('TEXT_FILESIZE_MEGS', ' MB');

// shopping cart errors
  define('ERROR_PRODUCT','Nome do produto: ');
  define('ERROR_PRODUCT_STATUS_SHOPPING_CART','<br />Lamentamos inform-lo que este produto foi removido do nosso inventrio.<br />Este item foi removido do seu Carrinho de Compras.');
  define('ERROR_PRODUCT_QUANTITY_MIN',' ... Erro nas quantidades mnimas - ');
  define('ERROR_PRODUCT_QUANTITY_UNITS',' ... Erro nas unidades de quantidade - ');
  define('ERROR_PRODUCT_OPTION_SELECTION','<br /> ... Os valores das opes que foram seleccionados so invlidos ');
  define('ERROR_PRODUCT_QUANTITY_ORDERED','<br /> Voc encomendou um total de: ');
  define('ERROR_PRODUCT_QUANTITY_MAX',' ... Erros nas quantidades mximas - ');
  define('ERROR_PRODUCT_QUANTITY_MIN_SHOPPING_CART',' ... Erros nas quantidades mnimas - ');
  define('ERROR_PRODUCT_QUANTITY_UNITS_SHOPPING_CART',' ... Erros nas unidades de quantidade - ');
  define('ERROR_PRODUCT_QUANTITY_MAX_SHOPPING_CART',' ... Erros nas quantidades mximas - ');

// error on checkout when $_SESSION['customers_id' does not exist in customers table
  define('ERROR_CUSTOMERS_ID_INVALID', 'A informao do cliente no pode ser validada!<br />Por favor, identifique-se ou crie novamente uma conta ...');

  define('TABLE_HEADING_FEATURED_PRODUCTS','Produtos catalogados');

  define('TABLE_HEADING_NEW_PRODUCTS', 'Novos produtos em %s');
  define('TABLE_HEADING_UPCOMING_PRODUCTS', 'Brevemente');
  define('TABLE_HEADING_DATE_EXPECTED', 'Data prevista');
  define('TABLE_HEADING_SPECIALS_INDEX', 'Especiais do ms em %s');

// meta tags special defines
  define('META_TAG_PRODUCTS_PRICE_IS_FREE_TEXT',' gratuito!');

// customer login
  define('TEXT_SHOWCASE_ONLY','Contacte-nos');
// set for login for prices
  define('TEXT_LOGIN_FOR_PRICE_PRICE','O preo no est disponvel');
  define('TEXT_LOGIN_FOR_PRICE_BUTTON_REPLACE','Identifique-se para saber o preo');
// set for show room only
  define('TEXT_LOGIN_FOR_PRICE_PRICE_SHOWROOM', ''); // blank for prices or enter your own text
  define('TEXT_LOGIN_FOR_PRICE_BUTTON_REPLACE_SHOWROOM','Montra de Produto');

// authorization pending
  define('TEXT_AUTHORIZATION_PENDING_PRICE', 'O preo no est disponvel');
  define('TEXT_AUTHORIZATION_PENDING_BUTTON_REPLACE', ' ESPERA DE APROVAO');
  define('TEXT_LOGIN_TO_SHOP_BUTTON_REPLACE','Identifique-se para comprar');

// text pricing
  define('TEXT_CHARGES_WORD','Clculo do valor a cobrar:');
  define('TEXT_PER_WORD','<br />Preo por palavra: ');
  define('TEXT_WORDS_FREE',' Palavra(s) grtis ');
  define('TEXT_CHARGES_LETTERS','Valor a cobrar estimado:');
  define('TEXT_PER_LETTER','<br />Preo por letra: ');
  define('TEXT_LETTERS_FREE',' Letra(s) grtis ');
  define('TEXT_ONETIME_CHARGES','*cobrana nica = ');
  define('TEXT_ONETIME_CHARGES_EMAIL',"\t" . '*cobrana nica = ');
  define('TEXT_ATTRIBUTES_QTY_PRICES_HELP', 'Opo Descontos de Quantidade');
  define('TABLE_ATTRIBUTES_QTY_PRICE_QTY','QTD');
  define('TABLE_ATTRIBUTES_QTY_PRICE_PRICE','PREO');
  define('TEXT_ATTRIBUTES_QTY_PRICES_ONETIME_HELP', 'Opo Descontos de Quantidade - Cobrana nica');

// textarea attribute input fields
  define('TEXT_MAXIMUM_CHARACTERS_ALLOWED',' nmero mximo de caracteres permitido');
  define('TEXT_REMAINING','restante');

// Shipping Estimator
  define('CART_Shipping_OPTIONS', 'Clculo das despesas de envio:');
  define('CART_SHIPPING_OPTIONS_LOGIN', 'Por favor, <a href="' . zen_href_link(FILENAME_LOGIN, '', 'SSL') . '"><span class="pseudolink">IDENTIFIQUE-SE</span></a>, para verificar as suas despesas de envio pessoais.');
  define('CART_SHIPPING_METHOD_TEXT', 'Mtodos de envio disponveis');
  define('CART_SHIPPING_METHOD_RATES', 'Preos');
  define('CART_SHIPPING_METHOD_TO','Enviar para: ');
  define('CART_SHIPPING_METHOD_TO_NOLOGIN', 'Enviar para: <a href="' . zen_href_link(FILENAME_LOGIN, '', 'SSL') . '"><span class="pseudolink">Identificar</span></a>');
  define('CART_SHIPPING_METHOD_FREE_TEXT', 'Envio gratuito');
  define('CART_SHIPPING_METHOD_ALL_DOWNLOADS', '- Downloads');
  define('CART_SHIPPING_METHOD_RECALCULATE', 'Recalcular');
  define('CART_SHIPPING_METHOD_ZIP_REQUIRED', 'verdadeiro');
  define('CART_SHIPPING_METHOD_ADDRESS', 'Endereo:');
  define('CART_OT','Estimativa dos custos totais:');
  define('CART_OT_SHOW','verdadeiro'); // set to false if you don't want order totals
  define('CART_ITEMS','Itens contidos no Carrinho de Compras: ');
  define('CART_SELECT','Seleccionar');
  define('ERROR_CART_UPDATE', 'Por favor, actualize a sua encomenda...<br />');
  define('IMAGE_BUTTON_UPDATE_CART', 'Actualizar');
  define('EMPTY_CART_TEXT_NO_QUOTE', 'A sua sesso expirou... Por favor, actualize o seu Carrinho de Compras por causa das despesas de envio ...');

// multiple product add to cart
  define('TEXT_PRODUCT_LISTING_MULTIPLE_ADD_TO_CART', 'Adicionar: ');
  define('TEXT_PRODUCT_ALL_LISTING_MULTIPLE_ADD_TO_CART', 'Adicionar: ');
  define('TEXT_PRODUCT_FEATURED_LISTING_MULTIPLE_ADD_TO_CART', 'Adicionar: ');
  define('TEXT_PRODUCT_NEW_LISTING_MULTIPLE_ADD_TO_CART', 'Adicionar: ');
  //moved SUBMIT_BUTTON_ADD_PRODUCTS_TO_CART to button_names.php as BUTTON_ADD_PRODUCTS_TO_CART_ALT

// discount qty table
  define('TEXT_HEADER_DISCOUNT_PRICES_PERCENTAGE', 'Descontos de quantidades - Preo');
  define('TEXT_HEADER_DISCOUNT_PRICES_ACTUAL_PRICE', 'Descontos de quantidade - Novo Preo');
  define('TEXT_HEADER_DISCOUNT_PRICES_AMOUNT_OFF', 'Descontos de quantidade - Preo');
  define('TEXT_FOOTER_DISCOUNT_QUANTITIES', '* Os descontos podero variar, de acordo com a configurao das opes acima mencionadas');
  define('TEXT_HEADER_DISCOUNTS_OFF', 'Descontos de quantidade no disponveis ...');

// sort order titles for dropdowns
  define('PULL_DOWN_ALL_RESET','- APAGAR - ');
  define('TEXT_INFO_SORT_BY_PRODUCTS_NAME', 'Nome do produto');
  define('TEXT_INFO_SORT_BY_PRODUCTS_NAME_DESC', 'Nome do produto - por ordem decrescente');
  define('TEXT_INFO_SORT_BY_PRODUCTS_PRICE', 'Preo - por ordem crescente');
  define('TEXT_INFO_SORT_BY_PRODUCTS_PRICE_DESC', 'Preo - por ordem decrescente');
  define('TEXT_INFO_SORT_BY_PRODUCTS_MODEL', 'Modelo');
  define('TEXT_INFO_SORT_BY_PRODUCTS_DATE_DESC', 'Dados adicionados - por ordem cronolgica decrescente');
  define('TEXT_INFO_SORT_BY_PRODUCTS_DATE', 'Dados adicionados - por ordem cronolgica crescente');
  define('TEXT_INFO_SORT_BY_PRODUCTS_SORT_ORDER', 'Exibio por defeito');

// downloads module defines
  define('TABLE_HEADING_DOWNLOAD_DATE', 'Cessamento da ligao');
  define('TABLE_HEADING_DOWNLOAD_COUNT', 'Restante');
  define('HEADING_DOWNLOAD', 'Para baixar os seus ficheiros, clique no boto de download e escolha "Salvar no disco" a partir do menu popup.');
  define('TABLE_HEADING_DOWNLOAD_FILENAME','Nome do ficheiro');
  define('TABLE_HEADING_PRODUCT_NAME','Nome do item');
  define('TABLE_HEADING_BYTE_SIZE','Tamanho do ficheiro');
  define('TEXT_DOWNLOADS_UNLIMITED', 'Ilimitado');
  define('TEXT_DOWNLOADS_UNLIMITED_COUNT', '--- *** ---');

// misc
  define('COLON_SPACER', ':&nbsp;&nbsp;');

// table headings for cart display and upcoming products
  define('TABLE_HEADING_QUANTITY', 'Qtd.');
  define('TABLE_HEADING_PRODUCTS', 'Nome do item');
  define('TABLE_HEADING_TOTAL', 'Total');

// create account - login shared
  define('TABLE_HEADING_PRIVACY_CONDITIONS', 'Poltica de privacidade');
  define('TEXT_PRIVACY_CONDITIONS_DESCRIPTION', 'Confirme por favor a sua concordncia com a nossa poltica de privacidade, assinalando a caixa de opo seguinte. A declarao de privacidade poder ser lida <a href="' . zen_href_link(FILENAME_PRIVACY, '', 'SSL') . '"><span class="pseudolink">aqui</span></a>.');
  define('TEXT_PRIVACY_CONDITIONS_CONFIRM', 'Li e concordo com a vossa poltica de privacidade.');
  define('TABLE_HEADING_ADDRESS_DETAILS', 'Detalhes do endereo');
  define('TABLE_HEADING_PHONE_FAX_DETAILS', 'Detalhes adicionais de contacto');
  define('TABLE_HEADING_DATE_OF_BIRTH', 'Verifique a sua idade');
  define('TABLE_HEADING_LOGIN_DETAILS', 'Detalhes de identificao');
  define('TABLE_HEADING_REFERRAL_DETAILS', 'Como  que tomou conhecimento de ns?');

  define('ENTRY_EMAIL_PREFERENCE','Detalhes referentes ao Boletim Informativo e Email:');
  define('ENTRY_EMAIL_HTML_DISPLAY','HTML');
  define('ENTRY_EMAIL_TEXT_DISPLAY','Apenas TEXTO');
  define('EMAIL_SEND_FAILED','ERRO: Falha no envio de email para: "%s" <%s> com o assunto: "%s"');

  define('DB_ERROR_NOT_CONNECTED', 'Erro - No foi possvel a ligao  base de dados');

// EZ-PAGES Alerts
  define('TEXT_EZPAGES_STATUS_HEADER_ADMIN', 'AVISO: EZ-PAGES HEADER  Ligado apenas para o Admin do IP');
  define('TEXT_EZPAGES_STATUS_FOOTER_ADMIN', 'AVISO: EZ-PAGES FOOTER - Ligado apenas para o Admin do IP');
  define('TEXT_EZPAGES_STATUS_SIDEBOX_ADMIN', 'AVISO: EZ-PAGES SIDEBOX - Ligado apenas para o Admin do IP');

// extra product listing sorter
  define('TEXT_PRODUCTS_LISTING_ALPHA_SORTER', '');
  define('TEXT_PRODUCTS_LISTING_ALPHA_SORTER_NAMES', 'Itens comeados por ...');
  define('TEXT_PRODUCTS_LISTING_ALPHA_SORTER_NAMES_RESET', '-- Apagar --');

///////////////////////////////////////////////////////////
// include email extras
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_EMAIL_EXTRAS)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_EMAIL_EXTRAS);

// include template specific header defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_HEADER)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_HEADER);

// include template specific button name defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_BUTTON_NAMES)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_BUTTON_NAMES);

// include template specific icon name defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_ICON_NAMES)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_ICON_NAMES);

// include template specific other image name defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_OTHER_IMAGES_NAMES)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_OTHER_IMAGES_NAMES);

// credit cards
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_CREDIT_CARDS)) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select. FILENAME_CREDIT_CARDS);

// include template specific whos_online sidebox defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/' . FILENAME_WHOS_ONLINE . '.php')) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . FILENAME_WHOS_ONLINE . '.php');

// include template specific meta tags defines
  if (file_exists(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir . '/meta_tags.php')) {
    $template_dir_select = $template_dir . '/';
  } else {
    $template_dir_select = '';
  }
  require(DIR_WS_LANGUAGES . $_SESSION['language'] . '/' . $template_dir_select . 'meta_tags.php');

// END OF EXTERNAL LANGUAGE LINKS
?>