DROP TABLE IF EXISTS products_attributes_images;

CREATE TABLE products_attributes_images (
	image_id INT NOT NULL AUTO_INCREMENT,
	products_attributes_id INT NOT NULL,
	image_path VARCHAR(255),
	image_title VARCHAR(255),
	image_sort_order INT,
	PRIMARY KEY(`image_id`)
);

INSERT INTO configuration_group
(configuration_group_id, configuration_group_title, configuration_group_description, sort_order, visible)
VALUES (NULL, 'AJAX 图片切换', 'AJAX 图片切换的选项', '1', '1');

UPDATE configuration_group SET sort_order = last_insert_id() WHERE configuration_group_id = last_insert_id();

SELECT @last_id :=last_insert_id() FROM configuration_group;

INSERT INTO configuration 
(configuration_id, configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added)
VALUES 
(NULL, '小图片高度', 'IMAGE_VIEWER_SMALL_IMAGE_HEIGHT','75','AJAX 图片切换中的小图片高度，显示缩略图。缺省为75', @last_id, 1, now()),
(NULL, '小图片宽度', 'IMAGE_VIEWER_SMALL_IMAGE_WIDTH','75','AJAX 图片切换中的小图片宽度，显示缩略图。缺省为75', @last_id, 5, now()),
(NULL, '中图片高度', 'IMAGE_VIEWER_MEDIUM_IMAGE_HEIGHT','300','AJAX 图片切换中的中图片高度。缺省为300', @last_id, 10, now()),
(NULL, '中图片宽度', 'IMAGE_VIEWER_MEDIUM_IMAGE_WIDTH','300','AJAX 图片切换中的中图片宽度。缺省为300', @last_id, 15, now()),
(NULL, '显示的图片数目', 'IMAGE_VIEWER_IMAGES_NUM','3','AJAX 图片切换中显示的图片数目', @last_id, 20, now());
