<?php
/* AJAX_image_swapper_server.php
 * PI = Product_Info
 * Made by Jaycode / Jay T (teguhwpurwanto@gmail.com)
 * 7 Oct 2007
*/
?>
<?php
if (isset($_GET['action'])) {
	chdir('../');
	require('includes/application_top.php');
	header('Content-Type: text/xml');
	$action = $_GET['action'];
	switch ($action) {
	case 'loadCategories':
		$sqlStr = "SELECT c.categories_id, categories_name 
							 FROM " . TABLE_CATEGORIES_DESCRIPTION . " cd, " . TABLE_CATEGORIES . " c 
							 WHERE c.categories_id = cd.categories_id AND cd.language_id = " . $_SESSION['languages_id'];
		$products = $db->Execute($sqlStr);
		$elements = array('categories_id','categories_name');
		$xmlStr = getXML($action, $products, $elements);
		echo $xmlStr;
		break;	
	case 'loadProducts':
		if (is_numeric($_GET['category_id'])) {
			$category_id = $_GET['category_id'];
		}
		else {
			$category_id = 0;
		}		
		$sqlStr = "SELECT DISTINCT p.products_id, products_name 
							 FROM " . TABLE_PRODUCTS_DESCRIPTION . " pd, " . TABLE_PRODUCTS . " p, " . TABLE_PRODUCTS_TO_CATEGORIES . " pc 
							 WHERE p.products_id = pd.products_id AND pc.categories_id = " . $category_id . " 
							 AND pd.language_id = " . $_SESSION['languages_id'] . " AND pc.products_id = p.products_id";
		$products = $db->Execute($sqlStr);
		$elements = array('products_id','products_name');
		$xmlStr = getXML($action, $products, $elements);
		echo $xmlStr;
		break;
	case 'loadAttributes':
		if (is_numeric($_GET['product_id'])) {
			$product_id = $_GET['product_id'];
		}
		else {
			$product_id = 0;
		}		
		$sqlStr = "SELECT DISTINCT o.products_options_id, products_options_name 
				   FROM " . TABLE_PRODUCTS_OPTIONS ." o, " . TABLE_PRODUCTS_ATTRIBUTES . " a 
				   WHERE o.products_options_id = a.options_id 
				   AND a.products_id = " . $product_id . " 
				   ORDER BY o.products_options_sort_order";
		$products = $db->Execute($sqlStr);
		$elements = array('products_options_id','products_options_name');
		$xmlStr = getXML($action, $products, $elements);
		echo $xmlStr;
		break;
	case 'loadOptions':
		if (is_numeric($_GET['product_id'])) {
			$product_id = $_GET['product_id'];
		}
		else {
			$product_id = 0;
		}
		
		if (is_numeric($_GET['attribute_id'])) {
			$attribute_id = $_GET['attribute_id'];
		}
		else {
			$attribute_id = 0;
		}
		$sqlStr = "SELECT a.products_attributes_id, products_options_values_name
				   FROM " . TABLE_PRODUCTS_OPTIONS_VALUES . " o, " . TABLE_PRODUCTS_ATTRIBUTES . " a 
				   WHERE o.products_options_values_id = a.options_values_id 
				   AND a.options_id = " . $attribute_id . " 
				   AND a.products_id = " . $product_id . " 
				   AND language_id = " . $_SESSION['languages_id'] . " 
				   ORDER BY o.products_options_values_sort_order";
		$products = $db->Execute($sqlStr);
		$elements = array('products_attributes_id','products_options_values_name');
		$xmlStr = getXML($action, $products, $elements);
		echo $xmlStr;
		break;
	case 'loadImages':
	case 'loadImagesFromIframe':
		if (is_numeric($_GET['option_id'])) {
			$option_id = $_GET['option_id'];
		}
		else {
			$option_id = 0;
		}
		$sqlStr = "SELECT image_id, image_path, image_title, image_sort_order 
				   FROM " . TABLE_PRODUCTS_ATTRIBUTES_IMAGES . " 
				   WHERE products_attributes_id = " . $option_id . " 
				   ORDER BY image_sort_order";
		$products = $db->Execute($sqlStr);
		$elements = array('image_id', 'image_path', 'image_title','image_sort_order');
		$xmlStr = getXML($action, $products, $elements);
		echo $xmlStr;
		break;
	case 'selectImage':
		if (is_numeric($_GET['image_id'])) {
			$image_id = $_GET['image_id'];
		}
		else {
			$image_id = 0;
		}
		$sqlStr = "SELECT image_path, image_sort_order, image_title  
				   FROM " . TABLE_PRODUCTS_ATTRIBUTES_IMAGES . " 
				   WHERE image_id = " . $image_id;
		$products = $db->Execute($sqlStr);
		$elements = array('image_path', 'image_sort_order', 'image_title');
		$xmlStr = getXML($action, $products, $elements);
		echo $xmlStr;
		break;
	case 'update':
		$new_order = (is_numeric($_GET['new_order'])) ? ($_GET['new_order']) : (0);
		$new_title = (is_string($_GET['new_title'])) ? ($_GET['new_title']) : (0);
		$image_id = (is_numeric($_GET['image_id'])) ? ($_GET['image_id']) : (0);
		$option_id = (is_numeric($_GET['option_id'])) ? ($_GET['option_id']) : (0);
		
		$sqlStr = "UPDATE " . TABLE_PRODUCTS_ATTRIBUTES_IMAGES . " 
				   SET image_sort_order = " . $new_order . ", 
					 image_title = '" . $new_title . "' 
				   WHERE image_id = " . $image_id;
		$db->Execute($sqlStr);
		
		$sqlStr = "SELECT image_id, image_path, image_title, image_sort_order 
				   FROM " . TABLE_PRODUCTS_ATTRIBUTES_IMAGES . " 
				   WHERE products_attributes_id = " . $option_id . " 
				   ORDER BY image_sort_order";
		$products = $db->Execute($sqlStr);
		$elements = array('image_id', 'image_path', 'image_title','image_sort_order');
		$xmlStr = getXML($action, $products, $elements);
		echo $xmlStr;
		break;
	case 'delImage':
		$image_id = (is_numeric($_GET['image_id'])) ? ($_GET['image_id']) : (0);
		$option_id = (is_numeric($_GET['option_id'])) ? ($_GET['option_id']) : (0);
		
		$sqlStr = "SELECT image_path 
				   FROM " . TABLE_PRODUCTS_ATTRIBUTES_IMAGES . "
				   WHERE image_id = " . $image_id;
		$result = $db->Execute($sqlStr);
		$image_path = $result->fields['image_path'];
		deleteImage($image_path);
		
		$sqlStr = "DELETE FROM " . TABLE_PRODUCTS_ATTRIBUTES_IMAGES . " 
				   WHERE image_id = " . $image_id;
		$db->Execute($sqlStr);
		
		$sqlStr = "SELECT image_id, image_path, image_title, image_sort_order 
				   FROM " . TABLE_PRODUCTS_ATTRIBUTES_IMAGES . " 
				   WHERE products_attributes_id = " . $option_id . " 
				   ORDER BY image_sort_order";
		$products = $db->Execute($sqlStr);
		$elements = array('image_id', 'image_path', 'image_title','image_sort_order');
		$xmlStr = getXML($action, $products, $elements);
		echo $xmlStr;
		break;
	}
}

/*
getXML function
$action = the name of action, returned as the value of attribute "action" of node "items"
$items = result of $db->Execute($sqlStr)
$elements = array of returned node tagNames
*/
function getXML($action, $items, $elements) {
	if ($items->recordCount() > 0) {
		$doc = new DomDocument('1.0');
		$itemsNode = $doc->createElement('items');
		$itemsNode = $doc->appendChild($itemsNode);
		$itemsNode->setAttribute('action',$action);
		while (!$items->EOF) {
			$itemNode = $doc->createElement('item');
			$itemNode = $itemsNode->appendChild($itemNode);
			for($i = 0; $i < count($elements); $i++) {
				$elementNode = $doc->createElement($elements[$i]);
				$elementNode = $itemNode->appendChild($elementNode);
				$valueNode = $doc->createTextNode($items->fields[$elements[$i]]);
				$valueNode = $elementNode->appendChild($valueNode);
			}
			$items->MoveNext();
		}
		$xmlStr = $doc->saveXML();
		return $xmlStr;
	}
	else {
		$doc = new DomDocument('1.0');
		$itemsNode = $doc->createElement('items');
		$itemsNode = $doc->appendChild($itemsNode);
		$itemsNode->setAttribute('action',$action);
		$itemNode = $doc->createElement('item');
		$itemNode = $itemsNode->appendChild($itemNode);

		$xmlStr = $doc->saveXML();
		return $xmlStr;
	}
}

function deleteImage($image_path) {
	chdir('../');
	$image_path_array = explode('.', $image_path);
	$large = '../' . $image_path_array[0] . '_LRG.' . $image_path_array[1];
	$medium = '../' . $image_path_array[0] . '_MED.' . $image_path_array[1];
	$small = '../' . $image_path;
	if (file_exists($large)) {
		unlink($large);
	}
	if (file_exists($medium)) {
		unlink($medium);
	}
	if (file_exists($small)) {
		unlink($small);
	}
}
?>