<?php
/* AJAX_image_swapper_server.php
 * PI = Product_Info
 * Made by Jaycode / Jay T (teguhwpurwanto@gmail.com)
 * 21 Oct 2007
*/
?>
<?php

if (isset($_GET['action'])) {
	chdir('../');
	include('includes/application_top.php');
	header('Content-Type: text/xml');
	$action = $_GET['action'];
	switch ($action) {
		case 'loadImages':
			$products_id = (is_numeric($_GET['products_id'])) ? ($_GET['products_id']) : (0);
			$options_id = (is_numeric($_GET['options_id'])) ? ($_GET['options_id']) : (0);
			$options_values_id = (is_numeric($_GET['options_values_id'])) ? ($_GET['options_values_id']) : (0);
			$sqlStr = "SELECT image_id, image_path, image_title, image_sort_order 
					   FROM " . TABLE_PRODUCTS_ATTRIBUTES_IMAGES . " i, " . TABLE_PRODUCTS_ATTRIBUTES . " a
					   WHERE i.products_attributes_id = a.products_attributes_id 
					   AND a.options_values_id = " . $options_values_id . " 
					   AND a.options_id = " . $options_id . " 
					   AND a.products_id = " . $products_id . "
						 ORDER BY i.image_sort_order";
			$products = $db->Execute($sqlStr);
			
			$items_array = array();
			$items_array = getItemsArray($products);
			
			$xml = array_to_xml($action, $items_array);
			echo $xml->saveXML();
			break;
		case 'showMedium':
			$image_id = (is_numeric($_GET['image_id'])) ? ($_GET['image_id']) : (0);
			$sqlStr = "SELECT image_id, image_path, image_title
					   FROM " . TABLE_PRODUCTS_ATTRIBUTES_IMAGES . " i 
					   WHERE i.image_id = " . $image_id;
			$products = $db->Execute($sqlStr);
			
			$items_array = array();
			$items_array = getItemsArray($products);
			
			$xml = array_to_xml($action, $items_array);
			echo $xml->saveXML();
			break;
	}
}
?>

<?php
function getItemsArray($products) {
	$items_array = array();
	if ($products->recordCount() > 0) {
		while (!$products->EOF) {
			$item_array = array();
			$item_array['image_id'] = $products->fields['image_id'];
			$image_path = $products->fields['image_path'];
			$image_path_arr = explode('.', $image_path);
			$image_path_medium = $image_path_arr[0] . '_MED.' . $image_path_arr[1];
			$image_path_large = $image_path_arr[0] . '_LRG.' . $image_path_arr[1];
			
			$image_path_medium = (file_exists($image_path_medium)) ? ($image_path_medium) : ($image_path);
			$image_path_large = (file_exists($image_path_large)) ? ($image_path_large) : ((file_exists($image_path_medium)) ? ($image_path_medium) : ($image_path));
			
			$item_array['image_path_small'] = $image_path;
			$small_size = getSize($image_path,IMAGE_VIEWER_SMALL_IMAGE_WIDTH, IMAGE_VIEWER_SMALL_IMAGE_HEIGHT);
			$item_array['image_width_small'] = $small_size['width'];
			$item_array['image_height_small'] = $small_size['height'];
			
			$item_array['image_path_medium'] = $image_path_medium;
			$medium_size = getSize($image_path_medium,IMAGE_VIEWER_MEDIUM_IMAGE_WIDTH, IMAGE_VIEWER_MEDIUM_IMAGE_HEIGHT);
			$item_array['image_width_medium'] = $medium_size['width'];
			$item_array['image_height_medium'] = $medium_size['height'];
			
			$item_array['image_path_large'] = $image_path_large;
			$image_size = @getimagesize($image_path_large);
			$item_array['image_width_large'] = $image_size[0];
			$item_array['image_height_large'] = $image_size[1];
			
			$item_array['image_title'] = $products->fields['image_title'];
			$item_array['image_sort_order'] = $products->fields['image_sort_order'];
			$items_array[] = $item_array;
			$products->MoveNext();
		}
	}
	return $items_array;
}
?>

<?php
function getSize($src, $width, $height) {
	$new_size = array();
	if ($image_size = @getimagesize($src)) {
		if (empty($width) && zen_not_null($height)) {
		  $ratio = $height / $image_size[1];
		  $width = $image_size[0] * $ratio;
		} elseif (zen_not_null($width) && empty($height)) {
		  $ratio = $width / $image_size[0];
		  $height = $image_size[1] * $ratio;
		} elseif (empty($width) && empty($height)) {
		  $width = $image_size[0];
		  $height = $image_size[1];
		}
	}
    if (zen_not_null($width) && zen_not_null($height) and file_exists($src)) {
//      $image .= ' width="' . zen_output_string($width) . '" height="' . zen_output_string($height) . '"';
// proportional images
      $image_size = @getimagesize($src);
      // fix division by zero error
      $ratio = ($image_size[0] != 0 ? $width / $image_size[0] : 1);
      if ($image_size[1]*$ratio > $height) {
        $ratio = $height / $image_size[1];
        $width = $image_size[0] * $ratio;
      } else {
        $height = $image_size[1] * $ratio;
      }
// only use proportional image when image is larger than proportional size
      if ($image_size[0] < $width and $image_size[1] < $height) {
		$new_size['width'] = $image_size[0];
		$new_size['height'] = $image_size[1];
      } else {
		$new_size['width'] = round($width);
		$new_size['height'] = round($height) ;
      }
    }
	return $new_size;
}
?>

<?php
/* Function array_to_xml($action, $items)
$action = the name of action, returned as the value of attribute "action" of node "items"
$items = associative array
example:
$action="loadImages" and $items = <see below>
Array
([0] => Array
        ( [image_id] => 20
          [image_path_small] => images/Hyperlite_Boards/BYERLY_52.jpg)
 [1] => Array
        ( [image_id] => 25
          [image_path_small] => images/Hyperlite_Boards/Cartel141S.jpg) 
)

is converted into this:
<items action="loadImages">
	<item>
		<image_id>20</image_id>
		<image_path_small>images/Hyperlite_Boards/BYERLY_52.jpg</image_path_small>
	</item>
	<item>
		<image_id>25</image_id>
		<image_path_small>images/Hyperlite_Boards/Cartel141S.jpg</image_path_small>
	</item>
</items>

*/
function array_to_xml($action, $items) {
	if (count($items) > 0) {
		$doc = new DomDocument('1.0');
		$itemsNode = $doc->createElement('items');
		$itemsNode = $doc->appendChild($itemsNode);
		$itemsNode->setAttribute('action',$action);
		for($i=0; $i < count($items); $i++) {
			$itemNode = $doc->createElement('item');
			$itemNode = $itemsNode->appendChild($itemNode);
			$item = $items[$i];
			foreach($item as $value) {
				$elementNode = $doc->createElement(key($item));
				$elementNode = $itemNode->appendChild($elementNode);
				$valueNode = $doc->createTextNode($value);
				$valueNode = $elementNode->appendChild($valueNode);
				next($item);
			}
		}
		return $doc;
	}
	else {
		$doc = new DomDocument('1.0');
		$itemsNode = $doc->createElement('items');
		$itemsNode = $doc->appendChild($itemsNode);
		$itemsNode->setAttribute('action',$action);
		$itemNode = $doc->createElement('item');
		$itemNode = $itemsNode->appendChild($itemNode);

		return $doc;
	}
}
?>

<?php
/*
getXML function
$action = the name of action, returned as the value of attribute "action" of node "items"
$items = result of $db->Execute($sqlStr)
$elements = array of returned node tagNames
*/
function getXML($action, $items, $elements) {
	if ($items->recordCount() > 0) {
		$doc = new DomDocument('1.0');
		$itemsNode = $doc->createElement('items');
		$itemsNode = $doc->appendChild($itemsNode);
		$itemsNode->setAttribute('action',$action);
		while (!$items->EOF) {
			$itemNode = $doc->createElement('item');
			$itemNode = $itemsNode->appendChild($itemNode);
			for($i = 0; $i < count($elements); $i++) {
				$elementNode = $doc->createElement($elements[$i]);
				$elementNode = $itemNode->appendChild($elementNode);
				$valueNode = $doc->createTextNode($items->fields[$elements[$i]]);
				$valueNode = $elementNode->appendChild($valueNode);
			}
			$items->MoveNext();
		}
		//$xmlStr = $doc->saveXML();
		return $doc;
	}
	else {
		$doc = new DomDocument('1.0');
		$itemsNode = $doc->createElement('items');
		$itemsNode = $doc->appendChild($itemsNode);
		$itemsNode->setAttribute('action',$action);
		$itemNode = $doc->createElement('item');
		$itemNode = $itemsNode->appendChild($itemNode);

		//$xmlStr = $doc->saveXML();
		return $doc;
	}
}
?>