<?php
/**
 * Common Template - tpl_header.php
 *
 * this file can be copied to /templates/your_template_dir/pagename<br />
 * example: to override the privacy page<br />
 * make a directory /templates/my_template/privacy<br />
 * copy /templates/templates_defaults/common/tpl_footer.php to /templates/my_template/privacy/tpl_header.php<br />
 * to override the global settings and turn off the footer un-comment the following line:<br />
 * <br />
 * $flag_disable_header = true;<br />
 *
 * @package templateSystem
 * @copyright Copyright 2003-2006 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: tpl_header.php 4813 2006-10-23 02:13:53Z drbyte $
 */
?>

<?php
  // Display all header alerts via messageStack:
  if ($messageStack->size('header') > 0) {
    echo $messageStack->output('header');
  }
  if (isset($_GET['error_message']) && zen_not_null($_GET['error_message'])) {
  echo htmlspecialchars(urldecode($_GET['error_message']));
  }
  if (isset($_GET['info_message']) && zen_not_null($_GET['info_message'])) {
   echo htmlspecialchars($_GET['info_message']);
} else {

}
?>


<!--bof-header logo and navigation display-->
<?php
if (!isset($flag_disable_header) || !$flag_disable_header) {
?>

<div id="headerWrapper">
<div id="header_box">
                    
            <!-- EDIT/INSERT YOUR LOGO BELOW --> 
                        <div id="zm_logo">
                        <div class="zm_logo_font">
                            <a href="<?php echo zen_href_link(FILENAME_DEFAULT); ?>" title="<?php echo STORE_NAME;?>">
                                <img src="<?php echo DIR_WS_TEMPLATE_IMAGES;?>logo.png" />
                            </a>    
                        </div>
                        </div>
                        
            <!-- END LOGO -->   
                       
            <div id="cart_content">
					<?php echo CART_ITEMS ?>&nbsp;<a><?php echo $_SESSION['cart']->count_contents() . '</a><br />' . TABLE_HEADING_TOTAL . '&nbsp;<a>' . $currencies->format($_SESSION['cart']->show_total());?></a> 
                    
                    <div id="currency_header">
                    <!-- Currencies -->

						<?php echo zen_draw_form('currencies', zen_href_link(basename(ereg_replace('.php','', $PHP_SELF)), '', $request_type, false), 'get')?>
                        
                        <?php
                        
                            if (isset($currencies) && is_object($currencies)) {
                        
                              reset($currencies->currencies);
                              $currencies_array = array();
                              while (list($key, $value) = each($currencies->currencies)) {
                                $currencies_array[] = array('id' => $key, 'text' => $value['title']);
                              }
                        
                              $hidden_get_variables = '';
                              reset($_GET);
                              while (list($key, $value) = each($_GET)) {
                                if ( ($key != 'currency') && ($key != zen_session_name()) && ($key != 'x') && ($key != 'y') ) {
                                  $hidden_get_variables .= zen_draw_hidden_field($key, $value);
                                }
                              }
                            }
                        
                        ?>
                        
                           Currency:&nbsp;<?php echo zen_draw_pull_down_menu('currency', $currencies_array, $_SESSION['currency'], 'class="header1_sel" onchange="this.form.submit();"') . $hidden_get_variables . zen_hide_session_id()?>
                        </form>
                        <!-- End Currencies -->
                    
                    
                    
                    </div>
                    
            </div>     			
        	
            <div id="cart_icon">
                <a href="<?php echo zen_href_link(FILENAME_SHOPPING_CART, '', 'NONSSL');?>"><img src="<?php echo DIR_WS_TEMPLATE_IMAGES;?>cartIcon.png" /></a>
            </div>
            
            
            <div id="login_header">
                
                

                <?php if ($_SESSION['customer_id']) { ?>

                <a href="<?php echo zen_href_link(FILENAME_LOGOFF, '', 'SSL'); ?>"><?php echo HEADER_TITLE_LOGOFF; ?></a>

                &nbsp;/&nbsp;<!--<li><a href="<?php echo zen_href_link(FILENAME_ACCOUNT_NEWSLETTERS, '', 'SSL'); ?>"><?php echo HEADER_TITLE_NEWSLETTERS; ?></a></li>-->

                <?php } else { ?>

                <a href="<?php echo zen_href_link(FILENAME_CREATE_ACCOUNT, '', 'SSL'); ?>">Register</a>
                &nbsp;/&nbsp;<a href="<?php echo zen_href_link(FILENAME_LOGIN, '', 'SSL'); ?>"><?php echo HEADER_TITLE_LOGIN; ?></a>

                

                <?php } ?>

             
        
            
            </div>
        
<br class="clearBoth" />

        
     


<!--bof-drop down menu display-->
<?php require($template->get_template_dir('tpl_drop_menu.php',DIR_WS_TEMPLATE, $current_page_base,'common'). '/tpl_drop_menu.php');?>
<!--eof-drop down menu display-->

    
        </div>


</div>

<?php } ?>